/* eslint-disable @typescript-eslint/no-explicit-any */
const envMap = new Map([
  ['baseUrl', 'BaseUrl'],
  ['remoteModelUrl', 'remoteDynaPath'],
  ['dcSystem', 'mockDcSystemId'],
  ['enablePermission', 'enablePermissionValid'],
]);

export async function attachEnvironmentConfig(): Promise<void> {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const env = (window as any).Environment;

  // environment.js里的值覆盖到ibiz.env里，名称不一致的按envMap映射去修改。
  Object.keys(ibiz.env).forEach(key => {
    const key2 = envMap.has(key) ? envMap.get(key)! : key;
    if (env[key2]) {
      if (key2 === 'customParams') {
        (ibiz.env as any)[key] = JSON.parse(env[key2]);
      } else {
        (ibiz.env as any)[key] = ibiz.util.rawValue.format(env[key2]);
      }
    }
  });

  if (env.AppTitle) {
    document.title = env.AppTitle;
  }

  if (env.favicon) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const faviconDom = document.getElementById('favicon') as any;
    if (faviconDom) {
      const imgTypes: IData = {
        '.png': 'image/png',
        '.gif': 'image/gif',
        '.ico': 'image/x-icon',
        '.svg': 'image/svg+xml',
      };
      const suffix = env.favicon.substring(env.favicon.lastIndexOf('.'));
      if (imgTypes[suffix]) {
        faviconDom.type = imgTypes[suffix];
      }
      faviconDom.href = env.favicon;
    }
  }

  ibiz.log.setLevel(ibiz.env.logLevel);
}
