import { computed, defineComponent } from 'vue';
import type { PropType } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/common/skeleton/skeleton-element/skeleton-element.scss';

export default defineComponent({
  props: {
    prefixClass: String,
    size: [String, Number] as PropType<
      'large' | 'medium' | 'small' | 'default' | number
    >,
    shape: String as PropType<'circle' | 'square' | 'round' | 'default'>,
    active: Boolean,
  },
  setup(props) {
    const ns = useNamespace(`skeleton-${props.prefixClass}`);

    const sizeClass = computed(() => {
      return typeof props.size === 'string' && props.size !== 'default'
        ? ns.m(props.size)
        : '';
    });

    const shapeClass = computed(() => {
      return props.shape && props.shape !== 'default' ? ns.m(props.shape) : '';
    });

    const sizeStyle = computed(() => {
      return typeof props.size === 'number'
        ? {
            width: `${props.size}px`,
            height: `${props.size}px`,
            lineHeight: `${props.size}px`,
          }
        : {};
    });

    return () => (
      <span
        class={`${ns.b()} ${sizeClass.value} ${shapeClass.value}`.trim()}
        style={sizeStyle.value}
      ></span>
    );
  },
});
