import { MiddlewareConsumer, Module } from '@nestjs/common';
import { ProxyMiddleware } from '../../middleware';

export class WorkFlowProxyMiddleware extends ProxyMiddleware {
  protected serviceTag = 'wfcore';

  use(req: any, res: any, next: () => void): void {
    const url: string = req.originalUrl;
    req.originalUrl = url.replace('/wfcore', '');
    super.use(req, res, next);
  }
}

/**
 * 高速缓存模块
 *
 * @author chitanda
 * @date 2021-08-18 21:08:12
 * @export
 * @class WorkflowModule
 */
@Module({})
export class WorkflowModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(WorkFlowProxyMiddleware).forRoutes('wfcore');
  }
}
