import { ILogicNode } from '@/interface/logic';
import { UIActionContext } from '../uiaction-context';
import { UILogicNodeBase } from './logic-node-base';
/**
 * 直接前台代码节点
 *
 * @export
 * @class UILogicRawCodeNode
 */
export class UILogicRawCodeNode extends UILogicNodeBase {

    constructor() {
        super();
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode 逻辑节点模型数据
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof UILogicRawCodeNode
     */
    public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            this.handleRawCode(logicNode, actionContext);
            return this.computeNextNodes(logicNode, actionContext);
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 处置直接执行代码
     *
     * @private
     * @param {ILogicNode} logicNode
     * @param {UIActionContext} actionContext
     * @memberof UILogicRawCodeNode
     */
    private handleRawCode(logicNode: ILogicNode, actionContext: UIActionContext) {
        // let data: any = actionContext.defaultParam.getReal();
        // let { context } = actionContext;
        // if (logicNode && logicNode.code) {
        //     eval(logicNode?.code);
        // } else {
        //     throw new Error('无代码片段');
        // }
        // actionContext.bindLastReturnParam(null);
    }
}