import { ILogicNode } from '@/interface/logic';
import { UIActionContext } from '../uiaction-context';
import { UILogicNodeBase } from './logic-node-base';
/**
 * 调试逻辑参数节点
 *
 * @export
 * @class UILogicDebugParamNode
 */
export class UILogicDebugParamNode extends UILogicNodeBase {

    constructor() {
        super();
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode 逻辑节点模型数据
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof UILogicDebugParamNode
     */
    public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            this.handleDebugParam(logicNode, actionContext);
            return this.computeNextNodes(logicNode, actionContext);
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error?.message ? error?.message : '发生未知错误！'}`);
        }
    }

    /**
     * 处理调试逻辑参数
     *
     * @private
     * @param {ILogicNode} logicNode
     * @param {UIActionContext} actionContext
     * @memberof UILogicDebugParamNode
     */
    private handleDebugParam(logicNode: ILogicNode, actionContext: UIActionContext) {
        // if (logicNode.getDstPSDEUILogicParam()) {
        //     const dstParamValue = actionContext.getParam(logicNode.getDstPSDEUILogicParam()?.codeName as string).getReal();
        //     actionContext.bindLastReturnParam(null);
        //     console.log(`逻辑节点${logicNode.name}操作参数值:`, dstParamValue);
        // }
    }
}