import { ILogicNode } from "@/interface/logic/logic-node";
import { UIActionContext } from '../uiaction-context';
import { UILogicNodeBase } from "./logic-node-base";

export class UILogicBeginNode extends UILogicNodeBase {
    /**
     * 执行节点
     *
     * @static
     * @param {IPSDELogicNode} logicNode 逻辑节点
     * @param {ActionContext} actionContext 逻辑上下文
     * @memberof AppDeLogicBeginNode
     */
     public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        // 默认设置当前逻辑返回结果为当前默认输入参数
        actionContext.setResult(actionContext.defaultParam.getReal());
        return this.computeNextNodes(logicNode, actionContext);
    }
}