import { ILogicNode } from "@/interface/logic";
import { UILogicNodeBase } from "./logic-node-base";
import { UIActionContext } from '../uiaction-context';

/**
 * 附加到数组参数节点
 *
 * @export
 * @class AppendParamNode
 * @extends {LogicNodeBase}
 */
export class UILogicAppendParamNode extends UILogicNodeBase {
    /**
     * 执行节点
     *
     * @static
     * @param {IPSDEAppendParamLogic} logicNode 逻辑节点
     * @param {UIActionContext} actionContext 逻辑上下文
     * @memberof AppDeLogicAppendParamNode
     */
    public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            this.onAppendParam(logicNode, actionContext);
            return this.computeNextNodes(logicNode, actionContext);
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error?.message ? error?.message : '发生未知错误！'}`);
        }
    }

    /**
     * 附加到数组
     *
     * @param {IPSDEAppendParamLogic} logicNode
     * @param {UIActionContext} actionContext
     * @memberof AppDeLogicAppendParamNode
     */
    public onAppendParam(logicNode: ILogicNode, actionContext: UIActionContext) {
        // 源数据
        const srcParam: any = actionContext.getParam(logicNode.srcParam as string);
        // 目标数据
        const dstParam: any = actionContext.getParam(logicNode.dstParam as string);
        // 源属性
        const srcFieldName: string = (logicNode.srcFieldName as string).toLowerCase();
        let objParam: any;
        if (srcFieldName) {
            // objParam = srcParam.get(srcFieldName);
            objParam = srcParam.getReal();
        } else {
            objParam = srcParam.getReal();
        }
        dstParam.append(logicNode.dstIndex, objParam, logicNode.srcIndex, logicNode.srcSize);
        actionContext.bindLastReturnParam(null);
    }
}