import { Subject } from 'rxjs';
import Vue from 'vue';
import { MessageBoxOptions } from './interface/message-box-options';
import appMessageBox from "./app-message-box.vue";
import i18n from '@/locale';
import store from '@/store';

/**
 * 提示信息
 *
 * @export
 * @class AppMessageBox
 */
export class AppMessageBox {
    /**
     * 唯一实例
     *
     * @private
     * @static
     * @memberof AppMessageBox
     */
    private static readonly instance = new AppMessageBox();

    /**
     * vue 实例
     *
     * @private
     * @type {Vue | null}
     * @memberof AppModal
     */
    private vueExample: Vue | null = null;


    /**
     * 引用对象
     *
     * @private
     * @type {*}
     * @memberof AppMessageBox
     */
    private refs: any;

    /**
     * 获取唯一实例
     *
     * @static
     * @return {*}  {AppMessageBox}
     * @memberof AppMessageBox
     */
    public static getInstance(): AppMessageBox {
        return AppMessageBox.instance;
    }


    /**
     * 打开提示信息
     *
     * @param {*} options
     * @return {*}
     * @memberof AppMessageBox
     */
    public open(options: any): Subject<any> {
        return this.createVueExample(options)
    }

    /**
     * 创建vue 实例
     *
     * @private
     * @param {ModalConfirmOptions} opt
     * @return {*}  {Subject<any>}
     * @memberof AppMessageBox
     */
    private createVueExample(opt: MessageBoxOptions): Subject<any> {
        const self: any = this;
        try {
            let props = { ...opt };
            this.vueExample = new Vue({
                store: store,
                i18n: i18n,
                render(h) {
                    return h(appMessageBox, { props, class: opt.customClass });
                }
            }).$mount();
            document.body.appendChild(this.vueExample.$el);
            this.refs = this.vueExample.$children[0];
            return this.refs.getSubject();
        } catch (error) {
            console.error(error);
            return new Subject<any>();
        }
    }

    /**
     * 关闭
     *
     * @memberof AppMessageBox
     */
    public close() {
        if (this.refs) {
            this.refs.close();
        }
    }

    /**
     * @description 销毁临时vue对象
     * @memberof AppModal
     */
    destroyVueExample() {
        if (this.vueExample) {
            this.vueExample.$destroy();
            this.vueExample = null;
        }
    }
}
