import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { UILogicParamBase } from "./ui-logic-param-base";

/**
 * 导航视图参数绑定参数
 *
 * @export
 * @class UILogicNavViewParam
 */
export class UILogicNavViewParam extends UILogicParamBase {

    /**
     * Creates an instance of UILogicNavViewParam.
     * @param {*} opts
     * @memberof UILogicNavViewParam
     */
    public constructor(opts: any) {
        super(opts);
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UILogicNavViewParam
     */
    protected init(params: any) {
        this.logicParamType = UILogicParamType.navViewParamParam;
        this.realValue = this.getNavViewParam(params);
    }

    /**
     * 获取导航视图参数绑定参数
     *
     * @private
     * @param {any} params
     * @memberof UILogicNavViewParam
     */
    private getNavViewParam(params: any) {
        return params.params;
    }
}