import { ViewTool } from './utils/view-tool/view-tool';
import { UIActionTool } from './utils/uiaction-tool/uiaction-tool';
import { Verify } from './utils/verify/verify';
import { Util } from './utils/util/util';
import { Http } from './utils/http/http';
import { exportExcel } from './utils/export/export';
import { AppPopover } from './utils/app-popover/app-popover';
import { AppModal } from './utils/app-modal/app-modal';
import { AppDrawer } from './utils/app-drawer/app-drawer';
import { uiServiceRegister } from '@/uiservice/ui-service-register';
import { authServiceRegister } from '@/authservice/auth-service-register';
import { utilServiceRegister } from '@/utilservice/util-service-register';
import { entityServiceRegister } from '@/service/entity-service-register';
import { counterServiceRegister } from '@/counter/counter-service-register';
import { codeListRegister } from '@codelist/codelist-register';
import { messageServiceRegister } from '@/message/message-service-register';

import InputBox from './components/input-box/input-box.vue'
import AppKeepAlive from './components/app-keep-alive/app-keep-alive.vue'
import TabPageExp from './components/tab-page-exp/tab-page-exp.vue'
import AppLang from './components/app-lang/app-lang.vue'
import AppTheme from './components/app-theme/app-theme.vue'
import AppUser from './components/app-user/app-user.vue'
import AppForm from './components/app-form/app-form.vue'
import APPAutocomplete from './components/app-autocomplete/app-autocomplete.vue'
import AppFormDruipart from './components/app-form-druipart/app-form-druipart.vue'
import DropdownList from './components/dropdown-list/dropdown-list.vue'
import DropdownListHidden from './components/dropdown-list-hidden/dropdown-list-hidden.vue'
import UploadFile from './components/upload-file/upload-file.vue'
import ContextMenuContainer from './components/context-menu-container/context-menu-container.vue'
import AppCheckboxList from './components/app-checkbox-list/app-checkbox-list.vue'
import AppRadioGroup from './components/app-radio-group/app-radio-group.vue'
import AppEmbedPicker from './components/app-embed-picker/app-embed-picker.vue'
import AppTreePicker from './components/app-tree-picker/app-tree-picker.vue'
import AppFileUpload from './components/app-file-upload/app-file-upload.vue'
import AppImageUpload from './components/app-image-upload/app-image-upload.vue'
import PropertyLayout from './components/property-layout/property-layout.vue'
import AppRangeEditor from './components/app-range-editor/app-range-editor.vue'
import AppExportExcel from './components/app-export-excel/app-export-excel.vue'
import AppFormGroup from './components/app-form-group/app-form-group.vue'
import AppFormItem from './components/app-form-item/app-form-item.vue'
import AppPicker from './components/app-picker/app-picker.vue'
import AppMpicker from './components/app-mpicker/app-mpicker.vue'
import AppUpicker from './components/app-upicker/app-upicker.vue'
import AppFormGroup2 from './components/app-form-group2/app-form-group2.vue'
import AppFormItem2 from './components/app-form-item2/app-form-item2.vue'
import CodeList from './components/codelist/codelist.vue'
import AppQuickMenus from './components/app-quick-menus/app-quick-menus.vue'
import AppIconMenus from './components/app-icon-menus/app-icon-menus.vue'
import AppCheckbox from './components/app-checkbox/app-checkbox.vue'
import AppColumnRender from './components/app-column-render/app-column-render.vue'
import AppPickerSelectView from './components/app-picker-select-view/app-picker-select-view.vue'
import AppSiderMenus from './components/app-sider-menus/app-sider-menus.vue'
import AppSpan from './components/app-span/app-span.vue'
import AppAddressSelection from './components/app-address-selection/app-address-selection.vue'
import DropdownListMpicker  from './components/dropdown-list-mpicker/dropdown-list-mpicker.vue'
import AppRate from './components/app-rate/app-rate.vue'
import AppSwitch from './components/app-switch/app-switch.vue'
import AppSlider from './components/app-slider/app-slider.vue'
import AppStepper from './components/app-stepper/app-stepper.vue'
import DatePickerRange from './components/date-picker-range/date-picker-range.vue'
import AppRangeDate from './components/app-range-date/app-range-date.vue'
import AppActionBar from './components/app-actionbar/app-actionbar.vue'
import AppOrgSector from  './components/app-orgsector/app-orgsector.vue'
import AppBuild from './components/app-build/app-build.vue'
import AppStudioAction from './components/app-studioaction/app-studioaction.vue'
import AppDebugActions from './components/app-debug-actions/app-debug-actions.vue'
import AppHeaderMenus from './components/app-header-menus/app-header-menus.vue'
import AppColumnLink from './components/app-column-link/app-column-link.vue'
import DropDownListDynamic from './components/dropdown-list-dynamic/dropdown-list-dynamic.vue'
import AppImagePreview from './components/app-image-preview/app-image-preview.vue'
import AppFormatData from './components/app-format-data/app-format-data.vue'
import AppUploadFileInfo from './components/app-upload-file-info/app-upload-file-info.vue'
import ContextMenu from './components/context-menu/context-menu'
import AppColumnFormat from './components/app-column-format/app-column-format.vue'
import AppQuickGroup from './components/app-quick-group/app-quick-group.vue'
import AppGroupPicker from './components/app-group-picker/app-group-picker.vue'
import AppWFApproval from './components/app-wf-approval/app-wf-approval.vue'
import Breadcrumb from './components/app-breadcrumb/app-breadcrumb.vue'
import AppTransfer from './components/app-transfer/app-transfer.vue'
import ContextMenuDrag from './components/context-menu-drag/context-menu-drag.vue'
import AppOrgSelect from './components/app-org-select/app-org-select.vue'
import AppDepartmentSelect from './components/app-department-select/app-department-select.vue'
import AppGroupSelect from './components/app-group-select/app-group-select.vue'
import UpdatePwd from './components/app-update-password/app-update-password.vue'
import AppMenuItem from './components/app-menu-item/app-menu-item.vue'
import AppFullScren from './components/app-full-scren/app-full-scren.vue'
import AppLockScren from './components/app-lock-scren/app-lock-scren.vue'
import ActionTimeline from './components/action-timeline/action-timeline.vue'
import CronEditor from './components/cron-editor/cron-editor.vue'
import AppMessagePopover from './components/app-message-popover/app-message-popover.vue'
import AppPanelField from './components/app-panel-field/app-panel-field.vue'
import AppPanelButton from './components/app-panel-button/app-panel-button.vue'
import AppDepartmentPersonnel from './components/app-department-personnel/app-department-personnel.vue'
import DiskFileUpload from './components/disk-file-upload/disk-file-upload.vue'
import AvueCustomForm  from './components/avue-custom-form/avue-custom-form.vue'
import DiskImageUpload from './components/disk-image-upload/disk-image-upload.vue'
import AppFormPart from './components/app-form-part/app-form-part.vue'
import AppAlert from './components/app-alert/app-alert.vue'
import AppAlertGroup from './components/app-alert-group/app-alert-group.vue'
import AppRawItem from './components/app-rawitem/app-rawitem.vue'
import AppImageRomate from './components/app-image-romate/app-image-romate.vue'
import { MenuIcon } from './components/menu-icon/menu-icon'
import AppVuePivottable from './components/app-vue-pivottable/app-vue-pivottable.vue';
import AppMapPosition from './components/app-map-position/app-map-position.vue';
import AppSortBar from './components/app-sort-bar/app-sort-bar.vue';
import AppAfterTime from './components/app-after-time/app-after-time.vue';
import AppInputIp from './components/app-input-ip/app-input-ip.vue';
import ButtonLoading  from  './directive/button-loading/button-loading';
import AppColorSpan  from  './components/app-color-span/app-color-span.vue';
import AppColorPicker from  './components/app-color-picker/app-color-picker.vue';
import AppScrollContainer from './components/layout-element/structure/app-scroll-container/app-scroll-container.vue';
import AppSimpleFlexContainer from './components/layout-element/structure/app-simpleflex-container/app-simpleflex-container.vue';
import AppStandardContainer from './components/layout-element/structure/app-standard-container/app-standard-container.vue';
import AppTabPanel from './components/layout-element/structure/app-tab-panel/app-tab-panel.vue';
import AppTabPage from './components/layout-element/structure/app-tab-page/app-tab-page.vue';
import AppNavPos from './components/layout-element/structure/app-nav-pos/app-nav-pos.vue';
import AppPresetText from './components/layout-element/text/app-preset-text/app-preset-text.vue';
import AppPresetCaption from './components/layout-element/text/app-preset-caption/app-preset-caption.vue';
import AppPresetTitle from './components/layout-element/text/app-preset-title/app-preset-title.vue';
import AppLoginInput from './components/layout-element/login/app-login-input/app-login-input.vue';
import AppLoginButton from './components/layout-element/login/app-login-button/app-login-button.vue';
import AppLoginOrg from './components/layout-element/login/app-login-org/app-login-org.vue';
import AppLoginMessage from './components/layout-element/login/app-login-message/app-login-message.vue';
import AppLoginThird from './components/layout-element/login/app-login-third/app-login-third.vue';
import AppLoginCaptcha from './components/layout-element/login/app-login-captcha/app-login-captcha.vue';
import AppLoginNoteVerify from './components/layout-element/login/app-login-note-verify/app-login-note-verify.vue';
import AppRawItemImage from './components/layout-element/media/app-rawitem-image/app-rawitem-image.vue';
import AppRawItemCarousel from './components/layout-element/media/app-rawitem-carousel/app-rawitem-carousel.vue';
import AppRawItemVideo from './components/layout-element/media/app-rawitem-video/app-rawitem-video.vue';
import AppPresetQrCode from './components/layout-element/interactive/app-preset-qrcode/app-preset-qrcode.vue';
import AppPresetSwitch from './components/layout-element/interactive/app-preset-switch/app-preset-switch.vue';
import AppPresetTextInput from './components/layout-element/interactive/app-preset-text-input/app-preset-text-input.vue';
import AppIndexNavTabs from './components/layout-element/index/app-index-nav-tabs/app-index-nav-tabs.vue';
import AppIndexNavBreadcrumb from './components/layout-element/index/app-index-nav-breadcrumb/app-index-nav-breadcrumb.vue';
import AppIndexOrgSelect from './components/layout-element/index/app-index-org-select/app-index-org-select.vue';
import AppIndexUserInfo from './components/layout-element/index/app-index-user-info/app-index-user-info.vue';
import AppCtrlPos from './components/layout-element/structure/app-ctrl-pos/app-ctrl-pos.vue';
import AppPresetButton from './components/layout-element/interactive/app-preset-button/app-preset-button.vue';
import AppFieldImageDynamic from './components/layout-element/media/app-field-image-dynamic/app-field-image-dynamic.vue';
import AppTodoList from './components/app-todo-list/app-todo-list.vue';
import ExtendActionTimeline from './components/extend-action-timeline/extend-action-timeline.vue';

// 全局挂载UI实体服务注册中心
window['uiServiceRegister'] = uiServiceRegister;
// 全局挂载实体权限服务注册中心
window['authServiceRegister'] = authServiceRegister;
// 全局挂载功能服务注册中心
window['utilServiceRegister'] = utilServiceRegister;
// 全局挂载数据服务注册中心
window['entityServiceRegister'] = entityServiceRegister;
// 全局挂载计数器服务注册中心
window['counterServiceRegister'] = counterServiceRegister;
// 全局挂载代码表服务注册中心
window['codeListRegister'] = codeListRegister;
// 全局挂载视图消息服务注册中心
window['messageServiceRegister'] = messageServiceRegister;

export const AppComponents = {
    install(v: any, opt: any) {
        v.prototype.$appdrawer = AppDrawer.getInstance();
        v.prototype.$appmodal = AppModal.getInstance();
        v.prototype.$apppopover = AppPopover.getInstance();
        v.prototype.$http = Http.getInstance();
        v.prototype.$export = exportExcel.getInstance();
        v.prototype.$util = Util;
        v.prototype.$verify = Verify;
        v.prototype.$viewTool = ViewTool;
        v.prototype.$uiActionTool = UIActionTool;
        v.component('app-department-personnel',AppDepartmentPersonnel);
        v.component('app-panel-button',AppPanelButton);
        v.component('app-panel-field',AppPanelField);
        v.component('app-full-scren',AppFullScren);
        v.component('app-lock-scren',AppLockScren);
        v.component('input-box', InputBox);
        v.component('app-keep-alive',AppKeepAlive);
        v.component('tab-page-exp',TabPageExp);
        v.component('app-lang',AppLang);
        v.component('app-theme',AppTheme);
        v.component('app-user',AppUser);
        v.component('app-form', AppForm);
        v.component('app-autocomplete', APPAutocomplete);
        v.component('app-form-druipart', AppFormDruipart);
        v.component('dropdown-list', DropdownList);
        v.component('dropdown-list-hidden', DropdownListHidden);
        v.component('upload-file', UploadFile);
        v.component('context-menu-container', ContextMenuContainer);
        v.component('app-checkbox-list',AppCheckboxList);
        v.component('app-radio-group',AppRadioGroup);
        v.component('app-embed-picker', AppEmbedPicker);
        v.component('app-tree-picker', AppTreePicker);
        v.component('app-rich-text-editor', () => import('./components/app-rich-text-editor/app-rich-text-editor.vue'));
        v.component('app-file-upload',AppFileUpload);
        v.component('app-image-upload',AppImageUpload);
        v.component('property-layout',PropertyLayout);
        v.component('app-range-editor',AppRangeEditor);
        v.component('app-export-excel',AppExportExcel);
        v.component('app-form-group',AppFormGroup);
        v.component('app-form-item',AppFormItem);
        v.component('app-picker', AppPicker);
        v.component('app-mpicker', AppMpicker);
        v.component('app-upicker', AppUpicker);
        v.component('app-form-group2', AppFormGroup2);
        v.component('app-form-item2', AppFormItem2);
        v.component('codelist', CodeList);
        v.component('app-quick-menus', AppQuickMenus);
        v.component('app-icon-menus', AppIconMenus);
        v.component('app-checkbox',AppCheckbox);
        v.component('app-column-render',AppColumnRender);
        v.component('app-picker-select-view',AppPickerSelectView);
        v.component('app-sider-menus',AppSiderMenus);
        v.component('app-span', AppSpan);
        v.component('app-address-selection', AppAddressSelection);
        v.component('dropdown-list-mpicker', DropdownListMpicker);
        v.component('app-rate', AppRate);
        v.component('app-switch', AppSwitch);
        v.component('app-slider', AppSlider);
        v.component('app-stepper', AppStepper);
        v.component('app-portal-design', () => import('./components/app-portal-design/app-portal-design.vue'));
        v.component('date-picker-range',DatePickerRange);
        v.component('app-range-date', AppRangeDate);
        v.component('app-actionbar', AppActionBar);
        v.component('app-orgsector', AppOrgSector);
        v.component('app-build', AppBuild);
        v.component('app-studioaction', AppStudioAction);
        v.component('app-debug-actions', AppDebugActions);
        v.component('app-header-menus', AppHeaderMenus);
        v.component('app-column-link', AppColumnLink);
        v.component('app-data-upload', () => import('./components/app-data-upload/app-data-upload.vue'));
        v.component('dropdown-list-dynamic', DropDownListDynamic);
        v.component('app-image-preview', AppImagePreview);
        v.component('app-format-data', AppFormatData);
        v.component('app-upload-file-info', AppUploadFileInfo);
        v.component('context-menu',ContextMenu);
        v.component('app-column-format',AppColumnFormat);
        v.component('app-quick-group',AppQuickGroup);
        v.component('app-org-select',AppOrgSelect);
        v.component('app-department-select',AppDepartmentSelect);
        v.component('app-group-select',AppGroupSelect);
        v.component('app-group-picker',AppGroupPicker);
        v.component('app-wf-approval',AppWFApproval);
        v.component('app-breadcrumb',Breadcrumb);
        v.component('app-transfer',AppTransfer);
        v.component('context-menu-drag',ContextMenuDrag);
        v.component('app-update-password',UpdatePwd);
        v.component('app-menu-item', AppMenuItem);
        v.component('action-timeline', ActionTimeline);
        v.component('cron-editor', CronEditor);
        v.component('app-message-popover', AppMessagePopover);
        v.component('disk-file-upload', DiskFileUpload);
        v.component('avue-custom-form', AvueCustomForm);
        v.component('disk-image-upload', DiskImageUpload);
        v.component('app-form-part', AppFormPart);
        v.component('app-alert', AppAlert);
        v.component('app-alert-group', AppAlertGroup);
        v.component('app-rawitem',AppRawItem);
        v.component('app-image-romate', AppImageRomate);
        v.component('menu-icon', MenuIcon);
        v.component('app-vue-pivottable', AppVuePivottable);
        v.component('app-map-position', AppMapPosition);
        v.component('app-sort-bar', AppSortBar);
        v.component('app-after-time', AppAfterTime);
        v.component('app-input-ip', AppInputIp);
        v.directive('button-loading',ButtonLoading);
        v.component('app-color-span', AppColorSpan);
        v.component('app-color-picker', AppColorPicker);
        v.component('app-scroll-container', AppScrollContainer);
        v.component('app-simpleflex-container',AppSimpleFlexContainer);
        v.component('app-standard-container',AppStandardContainer);
        v.component('app-tab-panel', AppTabPanel);
        v.component('app-tab-page', AppTabPage);
        v.component('app-nav-pos', AppNavPos);
        v.component('app-preset-text',AppPresetText);
        v.component('app-preset-caption',AppPresetCaption);
        v.component('app-preset-title',AppPresetTitle);
        v.component('app-login-input',AppLoginInput);
        v.component('app-login-button',AppLoginButton);
        v.component('app-login-org',AppLoginOrg);
        v.component('app-login-message',AppLoginMessage);
        v.component('app-login-third',AppLoginThird);
        v.component('app-login-captcha',AppLoginCaptcha);
        v.component('app-login-note-verify',AppLoginNoteVerify);
        v.component('app-rawitem-image', AppRawItemImage);
        v.component('app-rawitem-carousel', AppRawItemCarousel);
        v.component('app-rawitem-video', AppRawItemVideo);
        v.component('app-preset-qrcode',AppPresetQrCode);
        v.component('app-preset-switch',AppPresetSwitch);
        v.component('app-preset-text-input',AppPresetTextInput);
        v.component('app-index-nav-tabs', AppIndexNavTabs);
        v.component('app-index-nav-breadcrumb', AppIndexNavBreadcrumb);
        v.component('app-index-org-select', AppIndexOrgSelect);
        v.component('app-index-user-info', AppIndexUserInfo);
        v.component('app-ctrl-pos', AppCtrlPos);
        v.component('app-preset-button',AppPresetButton);
        v.component('app-field-image-dynamic', AppFieldImageDynamic);
        v.component('app-todo-list',AppTodoList);
        v.component('extend-action-timeline',ExtendActionTimeline);
    },
};