<#--  建立数据  -->
<#macro dataCreateObject item>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName]  父实体名称
     */
    public async ${item.getFullCodeName()}(args: any[], context: any = {}, params: any = {}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?: string) {
        <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
        // 准备上下文参数
        const tempContext = {...context};
        if (xData && xData.context) {
            Object.assign(tempContext, xData.context);
        }
        const data = args[0];
        const service = await window.entityServiceRegister.getService('${item.getPSAppDataEntity().getCodeName()}');
        if (service) {
            if (data.hasOwnProperty(service.APPDEKEY.toLowerCase())) {
                delete data[service.APPDEKEY.toLowerCase()];
            }
            try {
                service.Create(tempContext, data).then((response: any) => {
                    if (!response.status || response.status !== 200) {
                        this.$Notice.error({ title: '错误', desc: '当前环境无法执行建立数据逻辑[执行行为异常]' });
                    }
                })
            } catch (error: any) {
                this.$Notice.error({ title: '错误', desc: '当前环境无法执行建立数据逻辑[执行行为异常]' });
            }
        }
        <#else>
        this.$Notice.error({ title: '错误', desc: '建立数据行未配置实体' });
        </#if>
    }
</#macro>