<#ibizinclude>
./LAYOUTPANEL_VIEW.template.ftl
</#ibizinclude>

<#assign import_block>
import CodeListService from "@/codelist/codelist-service";
<#if view.getPSSysCounterRef?? && view.getPSSysCounterRef()?? && view.getPSSysCounterRef().getPSAppCounter()??>
<#assign appCounter = view.getPSSysCounterRef().getPSAppCounter() />
import  ${srfclassname('${appCounter.getCodeName()}')}CounterService  from '@/counter/${srffilepath2(appCounter.getCodeName())}/${srffilepath2(appCounter.getCodeName())}-counter';
</#if>
</#assign>

<#ibizinclude>
./VIEW_HEADER-BASE.vue.ftl
</#ibizinclude>

<#assign created_block>
if(this.formDruipart){
            this.formDruipart.subscribe((res:any) =>{
                if(Object.is(res.action,'save')){
                    this.viewState.next({ tag:'grid', action: 'save', data: this.viewparams });
                }
                if(Object.is(res.action,'load')){
                    const _this: any = this;
                    _this.engine.load(res.data,true);
                }
            });
        }
</#assign>

<#assign mounted_block>
<#if view.isEnableQuickGroup()>_this.loadQuickGroupModel();</#if>
</#assign>

<#ibizinclude>
./VIEW_CONTENT-BASE.vue.ftl
</#ibizinclude>

<#if view.hasPSControl('grid')>
<#assign grid = view.getPSControl('grid')>
</#if>
<#if grid??>
    /**
     * 是否单选
     *
     * @type {boolean}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public isSingleSelect: boolean = ${grid.isSingleSelect()?c};
</#if>

    <#if view.getPSSysCounterRef?? && view.getPSSysCounterRef?? && view.getPSSysCounterRef()?? && view.getPSSysCounterRef().getPSAppCounter()??>
    <#assign appCounter = view.getPSSysCounterRef().getPSAppCounter() />
    /**
     * ${srfclassname('${appCounter.getCodeName()}')}CounterService计数器服务对象
     *
     * @type {${srfclassname('${appCounter.getCodeName()}')}CounterService}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${appCounter.getCodeName()?lower_case}counterservice: ${srfclassname('${appCounter.getCodeName()}')}CounterService = new ${srfclassname('${appCounter.getCodeName()}')}CounterService({ $store: this.$store,context:this.context,viewparams:this.viewparams });
    </#if>

    /**
    * 是否嵌入关系界面
    *
    * @type {boolean}
    * @memberof ${srfclassname('${view.name}')}Base
    */
    @Prop({default:false}) public isformDruipart?: boolean;

    /**
    * 界面关系通讯对象
    *
    * @type {Subject<ViewState>}
    * @memberof ${srfclassname('${view.name}')}Base
    */
    @Prop() public formDruipart?: Subject<ViewState>;

    /**
     * 搜索值
     *
     * @type {string}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public query: string = '';

    /**
     * 是否展开搜索表单
     *
     * @type {boolean}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public isExpandSearchForm: boolean = ${view.isExpandSearchForm()?c};

    /**
     * 表格行数据默认激活模式
     * 0 不激活
     * 1 单击激活
     * 2 双击激活
     *
     * @type {(number | 0 | 1 | 2)}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public gridRowActiveMode: number | 0 | 1 | 2 = ${view.getGridRowActiveMode()?c};

    /**
     * 快速搜索
     *
     * @param {*} $event
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public onSearch($event: any): void {
        <#if grid??>
        const grid: any = this.$refs.${grid.name};
        if (grid) {
            grid.load(this.context, true);
        }
        </#if>
    }

    /**
     * grid 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof ENTITYTEST1Usr2GridViewBase
     */
    public onSave($event: any) {
        this.$emit('drdatasaved', $event);
    }
<#if grid??>

    /**
     * 刷新数据
     *
     * @readonly
     * @type {(number | null)}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    get refreshdata(): number | null {
        return this.$store.getters['viewaction/getRefreshData'](this.viewtag);
    }

    /**
     * 监控数据变化
     *
     * @param {*} newVal
     * @param {*} oldVal
     * @returns
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Watch('refreshdata')
    onRefreshData(newVal: any, oldVal: any) {
        if (newVal === null || newVal === undefined) {
            return;
        }
        if (newVal === 0) {
            return;
        }
        const grid: any = this.$refs.${grid.name};
        if (grid) {
            grid.load({});
        }
    }
</#if>

<#if view.isEnableQuickGroup()>

    /**
     * 代码表服务对象
     *
     * @type {CodeListService}
     * @memberof ${srfclassname('${view.name}')}Base
     */  
    public codeListService:CodeListService = new CodeListService({ $store: this.$store });

    /**
     * 快速分组数据对象
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public quickGroupData:any;

    /**
     * 快速分组是否有抛值
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public isEmitQuickGroupValue:boolean = false;

    /**
     * 快速分组模型
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public quickGroupModel:Array<any> = [];

    /**
     * 加载快速分组模型
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public loadQuickGroupModel(){
        <#if view.getQuickGroupPSCodeList()??>
        <#assign codelist=view.getQuickGroupPSCodeList() />
        let quickGroupCodeList:any = {tag:'${codelist.codeName}',codelistType:'${codelist.getCodeListType()}'};
        if(quickGroupCodeList.tag && Object.is(quickGroupCodeList.codelistType,"STATIC")){
            const codelist = this.$store.getters.getCodeList(quickGroupCodeList.tag);
            if (codelist) {
                this.quickGroupModel = [...this.handleDynamicData(JSON.parse(JSON.stringify(codelist.items)))];
            } else {
                <#noparse>console.log(`----${quickGroupCodeList.tag}----代码表不存在`);</#noparse>
            }
        }else if(quickGroupCodeList.tag && Object.is(quickGroupCodeList.codelistType,"DYNAMIC")){
            this.codeListService.getItems(quickGroupCodeList.tag,{},{}).then((res:any) => {
                this.quickGroupModel = res;
            }).catch((error:any) => {
                <#noparse>console.log(`----${quickGroupCodeList.tag}----代码表不存在`);</#noparse>
            });
        }
        </#if>
    }

    /**
     * 处理快速分组模型动态数据部分(%xxx%)
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public handleDynamicData(inputArray:Array<any>){
        if(inputArray.length >0){
            inputArray.forEach((item:any) =>{
               if(item.data && Object.keys(item.data).length >0){
                   Object.keys(item.data).forEach((name:any) =>{
                        let value: any = item.data[name];
                        if (value && typeof(value)=='string' && value.startsWith('%') && value.endsWith('%')) {
                            const key = (value.substring(1, value.length - 1)).toLowerCase();
                            if (this.context[key]) {
                                value = this.context[key];
                            } else if(this.viewparams[key]){
                                value = this.viewparams[key];
                            }
                        }
                        item.data[name] = value;
                   })
               }
            })
        }
        return inputArray;
    }

    /**
     * 快速分组值变化
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public quickGroupValueChange($event:any){
        if($event){
            this.quickGroupData = $event.data;
            if(this.isEmitQuickGroupValue){
                this.onSearch($event);
            }
        }
        this.isEmitQuickGroupValue = true;
    }
</#if>
<#if view.getQuickPSDESearchForm()??>

    /**
     * 快速搜索栏数据对象
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public quickFormData:any;

    /**
     * 快速搜索栏值变化
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public quickFormValueChange($event:any){
        this.quickFormData = $event;
        this.onSearch($event);
    }
</#if>
<#ibizinclude>
./VIEW_BOTTOM-BASE.vue.ftl
</#ibizinclude>

<#ibizinclude>
./VIEW-BASE.style.ftl
</#ibizinclude>