<#ibizinclude>
../../../@MACRO/LANG_FUN.ftl
</#ibizinclude>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
<#if item.getPSWFVersion?? && item.getPSWFVersion()??>
     * @memberof ${srfclassname('${item.getPSWFVersion().getCodeName()}')}WFUIService<#t>
<#elseif item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
     * @memberof ${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}UIService<#t>
</#if>
     */
    public async ${item.getFullCodeName()}(args: any[],context: any = {},params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string) {
    <#if item.render??>
        ${item.render.code}
    <#else>
    <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
    <#if item.getActionTarget() == 'SINGLEDATA'>
        actionContext.$Notice.error({ title: '错误', desc: '不支持单项数据' });
    <#elseif item.getActionTarget() == 'MULTIDATA'>
        actionContext.$Notice.error({ title: '错误', desc: '不支持多项数据' });
    <#else>
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        if(!args || args.length <1){
            console.error("错误,无数据传入");
        }
        let tempsrfmome:any = {srfwfmemo:args[0].srfwfmemo};
        <#-- 是否先保存目标数据start -->
        <#if item.isSaveTargetFirst()>
        const result:any = await xData.save(args,false);
        args = [result.data];
        </#if>
         <#-- 是否先保存目标数据end -->
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = <#if item.getActionTarget()??>'${item.getActionTarget()}'<#else>null</#if>;
    <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
    <#assign appDataEntity = item.getPSAppDataEntity() />
        <#if item.getActionTarget() == 'SINGLEKEY' || item.getActionTarget() == 'MULTIKEY'>
        <#assign valueItem><#if item.getValueItem?? && item.getValueItem() != ''>${item.getValueItem()}<#else>${appDataEntity.getKeyPSAppDEField().getCodeName()?lower_case}</#if></#assign>
        <#assign paramItem><#if item.getParamItem?? && item.getParamItem() != ''>${item.getParamItem()}<#else>${appDataEntity.getKeyPSAppDEField().getCodeName()?lower_case}</#if></#assign>
        <#assign textItem><#if item.getTextItem?? && item.getTextItem() != ''>${item.getTextItem()}<#else>${appDataEntity.getMajorPSAppDEField().getCodeName()?lower_case}</#if></#assign>
        <#if valueItem == paramItem>
        Object.assign(context, { ${appDataEntity.getCodeName()?lower_case}: '%${valueItem}%' });
        Object.assign(params, { ${valueItem}: '%${valueItem}%' });
        Object.assign(params, { ${textItem}: '%${textItem}%' })
        <#else>
        Object.assign(context, { ${appDataEntity.getCodeName()?lower_case}: '%${paramItem}%' });
        Object.assign(params, { ${valueItem}: '%${paramItem}%' });
        Object.assign(params, { ${textItem}: '%${textItem}%' });
        </#if>
        </#if>
    </#if>
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        //转化表单界面数据
        const resultData:any = xData.service.handleRequestData('',actionContext.context,_args[0]);
        Object.assign(context,resultData.context,context);
        Object.assign(data,resultData.data,{viewparams:actionContext.viewparams});
        Object.assign(data,tempsrfmome);
        <#-- 构建srfparentdename和srfparentkey start -->
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        <#-- 构建srfparentdename和srfparentkey end -->
        const backend = () => {
        <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
            const curService:${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}Service =  new ${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}Service();
            curService.WFSubmit(context,data, ${item.isShowBusyIndicator()?c}).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                <#if item.getSuccessMsg?? && item.getSuccessMsg()??>
                actionContext.$Notice.success({ title: '成功', desc: '${item.getSuccessMsg()}' });
                <#else>
                actionContext.$Notice.success({ title: '成功', desc: '${item.getCaption()}成功！' });
                </#if>
                <#--  if(window.opener){
                    window.opener.postMessage({status:'OK',identification:'WF'},Environment.uniteAddress);
                    window.close();
                }  -->
                return response;
            }).catch((response: any) => {
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: '错误', desc: '系统异常！' });
                    return;
                }
                if (response.status === 401) {
                    return;
                }
                return null;
            });
        </#if>
        };
        <#if item.getFrontPSAppView()??>
        <#assign frontview = item.getFrontPSAppView()>
        <#if frontview.getOpenMode()?index_of('DRAWER') == 0>
        const view: any = {
            viewname: '${srffilepath2(frontview.getCodeName())}',
            title: actionContext.<@getViewLanguageTitle frontview />,
            height: ${frontview.getHeight()?c},
            width: ${frontview.getWidth()?c},
            placement: '${frontview.getOpenMode()}'
        };
        const appdrawer = actionContext.$appdrawer.openDrawer(view,context,data);
        appdrawer.subscribe((result: any) => {
            if (result && Object.is(result.ret, 'OK')) {
                Object.assign(data, { srfactionparam: result.datas });
                backend();
            }
        });
        <#else>
        const view = { 
            viewname: '${srffilepath2(frontview.getCodeName())}', 
            title: actionContext.<@getViewLanguageTitle frontview />,
            height: ${frontview.getHeight()?c}, 
            width: ${frontview.getWidth()?c}, 
        };
        const appmodal = actionContext.$appmodal.openModal(view,context,data);
        appmodal.subscribe((result:any) => {
            if (result && Object.is(result.ret, 'OK')) {
                Object.assign(data, { srfactionparam: result.datas });
                backend();
            }
        });
        </#if>
    <#elseif item.getConfirmMsg?? && item.getConfirmMsg()??>
        actionContext.$Modal.confirm({
            title: '警告',
            content: '${item.getConfirmMsg()}',
            onOk: () => {
                backend();
            },
            onCancel: () => { }
        });
    <#else>
        backend();
    </#if>
</#if>
</#if>  
</#if>   
    }