<#ibizinclude>
../../../@MACRO/LANG_FUN.ftl
</#ibizinclude>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
<#if item.getPSWFVersion?? && item.getPSWFVersion()??>
     * @memberof ${srfclassname('${item.getPSWFVersion().getCodeName()}')}WFUIService<#t>
<#elseif item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
     * @memberof ${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}UIService<#t>
</#if>
     */
    public async ${item.getFullCodeName()}(args: any[],context: any ={}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
    <#if item.render??>
        ${item.render.code}
    <#else>
    <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
        <#if item.getFrontPSAppView()??>
        <#assign dataview = item.getFrontPSAppView()>
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        <#if item.getPSNavigateContexts?? && item.getPSNavigateContexts()??>
        Object.assign(context,<@getNavigateContext item />);
        </#if>
        <#if item.getPSNavigateParams?? && item.getPSNavigateParams()??>
        Object.assign(params,<@getNavigateParams item />);
        </#if>
        <#-- 是否先保存目标数据start -->
        <#if item.isSaveTargetFirst()>
        const result:any = await xData.save(args,false);
        args = [result.data];
        </#if>
         <#-- 是否先保存目标数据end -->
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = <#if item.getActionTarget()??>'${item.getActionTarget()}'<#else>null</#if>;
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        //转化表单界面数据
        const resultData:any = xData.service.handleRequestData('',actionContext.context,_args[0]);
        Object.assign(context,resultData.context,context);
        Object.assign(data,resultData.data,{viewparams:actionContext.viewparams});
        <#-- 构建srfparentdename和srfparentkey start -->
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        <#-- 构建srfparentdename和srfparentkey end -->
        <#--  BEGIN：是否应用实体视图  -->
        <#if dataview.isPSDEView()>
        <#-- 存在关系start -->
        <#if dataview.getPSAppDERSPathCount() gt 0>
        <#list 1..dataview.getPSAppDERSPathCount() as count>
        <#assign condition = ''/>
        <#list dataview.getPSAppDERSPath(count_index)  as deRSPath>
            <#if deRSPath.getMajorPSAppDataEntity?? && deRSPath.getMajorPSAppDataEntity()??>
                <#assign _dataEntity = deRSPath.getMajorPSAppDataEntity()/>
                <#assign condition>${condition}context.${_dataEntity.getCodeName()?lower_case} && </#assign>
            </#if>
        </#list>
        </#list>
        let deResParameters: any[] = [];
        <#-- 如果是主实体需对context判断start -->
        <#if dataview.getPSAppDataEntity().isMajor()>
        if(${condition}true){
            deResParameters = [
            <#list dataview.getPSAppDERSPath(dataview.getPSAppDERSPathCount() - 1) as deRSPath>
            <#assign majorPSAppDataEntity = deRSPath.getMajorPSAppDataEntity()/>
            { pathName: '${srfpluralize(majorPSAppDataEntity.codeName)?lower_case}', parameterName: '${majorPSAppDataEntity.getCodeName()?lower_case}' },
            </#list>
            ]
        }
        <#else>
        deResParameters = [
            <#list dataview.getPSAppDERSPath(dataview.getPSAppDERSPathCount() - 1) as deRSPath>
            <#assign majorPSAppDataEntity = deRSPath.getMajorPSAppDataEntity()/>
            { pathName: '${srfpluralize(majorPSAppDataEntity.codeName)?lower_case}', parameterName: '${majorPSAppDataEntity.getCodeName()?lower_case}' },
            </#list>
        ];
        </#if>
        <#-- 如果是主实体需对context判断end -->
        <#else>
        let deResParameters: any[] = [];
        </#if>
        <#-- 存在关系end -->
        <#else>
        const deResParameters: any[] = [];
        </#if>
        <#--  END：是否应用实体视图  -->
        <#--  BEGIN：是否应用实体视图  -->
        <#if dataview.isPSDEView()>
        <#assign appDataEntity = dataview.getPSAppDataEntity()/>
        const parameters: any[] = [
            { pathName: '${srfpluralize(appDataEntity.codeName)?lower_case}', parameterName: '${appDataEntity.getCodeName()?lower_case}' },
        ];
        <#else>
        const parameters: any[] = [];
        </#if>
        <#--  END：是否应用实体视图  -->
        <#if dataview.getOpenMode() =='INDEXVIEWTAB' || dataview.getOpenMode() == '' >
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            <#--  BEGIN 是否重新加载数据  -->
            <#if item.isReloadData?? && item.isReloadData()>
            if (xData && xData.refresh && xData.refresh instanceof Function) {
                xData.refresh(args);
            } else if (_this.refresh && _this.refresh instanceof Function) {
                _this.refresh(args);
            }
            </#if>
            <#--  END 是否重新加载数据  -->
            <#--  BEGIN 后续界面行为  -->
            <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
            <#assign nextPSUIAction = item.getNextPSUIAction()/>
            if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                this.${nextPSUIAction.getFullCodeName()}([data],context,params, $event, xData,actionContext);
            }
            </#if>
            <#--  END 后续界面行为  -->
            return null;
        }
        openIndexViewTab(data);
        <#elseif dataview.getOpenMode() = 'POPUPMODAL'>
        <#--  打开模态  -->
        const openPopupModal = (view: any, data: any) => {
            let container: Subject<any> = actionContext.$appmodal.openModal(view, context, data);
            container.subscribe((result: any) => {
                if (!result || !Object.is(result.ret, 'OK')) {
                    return;
                }
                <#--  是否重新加载数据  -->
                actionContext.closeView();
                <#--  if(window.opener){
                    window.opener.postMessage({status:'OK',identification:'WF'},Environment.uniteAddress);
                    window.close();
                }  -->
            });
        }
        const view: any = {
            viewname: '${srffilepath2(dataview.getCodeName())}', 
            height: ${dataview.getHeight()?c}, 
            width: ${dataview.getWidth()?c},  
            title: actionContext.<@getViewLanguageTitle dataview />, 
        };
        openPopupModal(view, data);
        <#elseif dataview.getOpenMode()?index_of('DRAWER') == 0>
         const openDrawer = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$appdrawer.openDrawer(view, context,data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    <#--  是否重新加载数据  -->
                    actionContext.closeView();
                    <#--  if(window.opener){
                        window.opener.postMessage({status:'OK',identification:'WF'},Environment.uniteAddress);
                        window.close();
                    }  -->
                });
            }
            const view: any = {
                viewname: '${srffilepath2(dataview.getCodeName())}', 
                height: ${dataview.getHeight()?c}, 
                width: ${dataview.getWidth()?c},  
                title: actionContext.<@getViewLanguageTitle dataview />, 
                placement: '${dataview.getOpenMode()}',
            };
            openDrawer(view, data);
        <#elseif dataview.getOpenMode() == 'POPOVER'>
            const openPopOver = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$apppopover.openPop($event, view, context, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    <#--  是否重新加载数据  -->
                    actionContext.closeView();
                    <#--  if(window.opener){
                        window.opener.postMessage({status:'OK',identification:'WF'},Environment.uniteAddress);
                        window.close();
                    }  -->
                });
            }
            const view: any = {
                viewname: '${srffilepath2(dataview.getCodeName())}', 
                height: ${dataview.getHeight()?c}, 
                width: ${dataview.getWidth()?c},  
                title: actionContext.<@getViewLanguageTitle dataview />, 
                placement: '${dataview.getOpenMode()}',
            };
            openPopOver(view, data);
        <#else>
            actionContext.$Notice.warning({ title: '错误', desc: actionContext.<@getViewLanguageTitle dataview />+'不支持该模式打开' });
        </#if>
        </#if>
    </#if>
    </#if>
    }