<#macro getViewLanguageTitle tempView>
  <#if tempView.isPSDEView()>
    $t('entities.${tempView.getPSAppDataEntity().getCodeName()?lower_case}.views.${tempView.getPSDEViewCodeName()?lower_case}.title')<#t>
  <#else>
    $t('app.views.${tempView.getCodeName()?lower_case}.title')<#t>
  </#if>
</#macro>

<#-- 获取导航上下文 -->
<#macro getNavigateContext currentItem>
{<#t>
  <#if currentItem.getPSNavigateContexts?? && currentItem.getPSNavigateContexts()??>
  <#list currentItem.getPSNavigateContexts() as navContext>
  ${navContext.getKey()}:<#if navContext.isRawValue()?? && navContext.isRawValue() == true>"${navContext.getValue()}"<#else>"%${navContext.getValue()}%"</#if><#if navContext_has_next>,</#if><#t>
  </#list>
  </#if>
}<#t>
</#macro>

<#-- 获取导航参数 -->
<#macro getNavigateParams currentItem>
{<#t>
<#if currentItem.getPSNavigateParams?? && currentItem.getPSNavigateParams()??>
<#list currentItem.getPSNavigateParams() as navParam >
${navParam.getKey()}:<#if navParam.isRawValue()?? && navParam.isRawValue() == true>"${navParam.getValue()}"<#else>"%${navParam.getValue()}%"</#if><#if navParam_has_next>,</#if><#t>
</#list>
</#if>
}<#t>
</#macro>

<#-- 属性值规则 -->
<#macro getDeRule condItem deRule curAppEntity>
                  {
                      type:"<#if condItem.getCondType?? && condItem.getCondType()??>${condItem.getCondType()}</#if>",
                      condOP:"<#if condItem.getCondOp?? && condItem.getCondOp()??>${condItem.getCondOp()}</#if>",
                      ruleInfo:"<#if condItem.getRuleInfo?? && condItem.getRuleInfo()??>${condItem.getRuleInfo()}</#if>", 
                      <#--  ruleInfo:`<#noparse>${</#noparse>this.$t('entities.${curAppEntity.getCodeName()?lower_case}.derules.${deRule.getCodeName()?lower_case}<#if condItem.getDEFName?? && condItem.getDEFName()??>${condItem.getDEFName()?lower_case}</#if>${condItem.getCondType()?lower_case}')<#noparse>}</#noparse>`,   -->
                      isKeyCond:<#if condItem.isKeyCond?? && condItem.isKeyCond()??>${condItem.isKeyCond()?c}</#if>,
                      <#if condItem.getParamValue?? && condItem.getParamValue()??>
                      paramValue:"${condItem.getParamValue()}",
                      </#if>
                      <#if condItem.getParamType?? && condItem.getParamType()??>
                      paramType:"${condItem.getParamType()}",
                      </#if>
                      <#if condItem.isNotMode?? && condItem.isNotMode()??>
                      isNotMode:${condItem.isNotMode()?c},
                      </#if>
                      <#if condItem.getRegExCode?? && condItem.getRegExCode()??>
                      regExCode:/${condItem.getRegExCode()}/,
                      </#if>
                      <#if condItem.getMaxValue?? && condItem.getMaxValue()??>
                      maxValue:${condItem.getMaxValue()?c},
                      </#if>
                      <#if condItem.getMinValue?? && condItem.getMinValue()??>
                      minValue:${condItem.getMinValue()?c},
                      </#if>
                      <#if condItem.getDEFName?? && condItem.getDEFName()??>
                      deName:"${condItem.getDEFName()?lower_case}",
                      </#if>
                      <#if condItem.isIncludeMaxValue?? && condItem.isIncludeMaxValue()??>
                      isIncludeMaxValue:${condItem.isIncludeMaxValue()?c},
                      </#if>
                      <#if condItem.isIncludeMinValue?? && condItem.isIncludeMinValue()??>
                      isIncludeMinValue:${condItem.isIncludeMinValue()?c},
                      </#if>
                      <#if condItem.getPSSysValueRule?? && condItem.getPSSysValueRule()??>
                      <#assign valRule = condItem.getPSSysValueRule()>
                      sysRule:{
                        ruleType:"<#if valRule.getRuleType?? && valRule.getRuleType()??>${valRule.getRuleType()}</#if>", 
                        ruleInfo:"<#if valRule.getRuleInfo?? && valRule.getRuleInfo()??>${valRule.getRuleInfo()}</#if>",
                        <#if valRule.getRuleType?? && valRule.getRuleType()?? && valRule.getRuleType() == "REG" && valRule.getRegExCode?? && valRule.getRegExCode()?? >
                        regExCode:/${valRule.getRegExCode()}/,
                        </#if>
                      },
                      </#if>
                      <#if condItem.getCondType?? && condItem.getCondType()?? && condItem.getCondType() == 'GROUP'>
                      group:[
                        <#if condItem.getPSDEFVRConditions?? && condItem.getPSDEFVRConditions()??>
                          <#list condItem.getPSDEFVRConditions() as group_item>
                                  <@getDeRule group_item deRule curAppEntity />
                          </#list>
                        </#if>
                        ]
                      </#if>
                  },
</#macro>