    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} contextJO 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${item.getFullCodeName()}(args: any[],contextJO?:any, params?: any, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
        const that: any = this;
        if (!xData || !(xData.wfstart instanceof Function)) {
            return;
        }
        let validateStatus: boolean = true;
        if (xData.formValidateStatus && xData.formValidateStatus instanceof Function) {
            validateStatus = xData.formValidateStatus();
        }
        if (!validateStatus) {
            return;
        }
        const startWorkFlow: Function = (param: any, localdata: any) => {
            <#if view.getPSWorkflow()??>
            <#assign curWorkflow = view.getPSWorkflow() />
            <#-- 通过是否使用代理模式来区分流程启动的模式 -->
            <#if curWorkflow.isUseWFProxyApp()>
            xData.wfstart(args).then((response: any) => {
            <#else>
            xData.wfstart(args,localdata).then((response: any) => {
            </#if>
            <#else>
            xData.wfstart(args).then((response: any) => {
            </#if>
                if (!response || response.status !== 200) {
                    return;
                }
                const { data: _data } = response;
                that.closeView(_data);
            });
        }
        const openStartView: Function = async (item: any, localdata: any) => {
            if (item['wfversion']) {
                <#noparse>const targetView: any = that.viewRefData ? that.viewRefData[`WFSTART@${item['wfversion']}`] : null;</#noparse>
                if (targetView) {
                    const tempContext = Util.deepCopy(that.context);
                    <#noparse>const tempViewParams = { actionView: `WFSTART@${item['wfversion']}`, actionForm: item['process-form'] };</#noparse>
                    const container: Subject<any> = that.$appmodal.openModal(targetView, tempContext, tempViewParams);
                    container.subscribe((result: any) => {
                        if (!result || !Object.is(result.ret, 'OK')) {
                            return;
                        }
                        const tempSubmitData: any = Util.deepCopy(args[0]);
                        if (result.datas && result.datas[0]) {
                            const resultData: any = result.datas[0];
                            if (Object.keys(resultData).length > 0) {
                                let tempData: any = {};
                                Object.keys(resultData).forEach((key: any) => {
                                    if (resultData[key] || (resultData[key] === 0) || (resultData[key] === false)) {
                                        tempData[key] = resultData[key];
                                    }
                                })
                                Object.assign(tempSubmitData, tempData);
                            }
                        }
                        startWorkFlow([tempSubmitData], localdata);
                    })
                } else {
                    startWorkFlow(args, localdata);
                }
            } else {
                startWorkFlow(args, localdata);
            }
        }
        let localData: any;
        const localContext = Util.deepCopy(that.context);
        const requestResult: Promise<any> = that.appEntityService.getStandWorkflow(localContext);
        requestResult.then((response: any) => {
            const { data: targetData, status } = response;
            if (status !== 200 || targetData.length === 0) {
                return;
            }
            if (targetData && targetData.length > 1) {
                const h = that.$createElement;
                targetData.forEach((element: any) => {
                    Object.assign(element, { value: element.definitionkey, label: element.definitionname });
                })
                that.$msgbox({
                    title: '请选择流程版本',
                    message: h('i-select', {
                        key: Util.createUUID(),
                        props: {
                            value: localData,
                            placeholder: "请选择流程版本...",
                            transfer: true,
                            transferClassName: "start-workflow-select-wraper"
                        },
                        on: {
                            'on-change': ($event: any) => {
                                localData = { processDefinitionKey: $event };
                            }
                        }
                    }, targetData.map((item: any) => {
                        return h('i-option', {
                            key: item.value,
                            props: {
                                value: item.value,
                                label: item.label
                            }
                        })
                    })),
                    showCancelButton: true,
                    confirmButtonText: '确定',
                    cancelButtonText: '取消'
                }).then((action: string) => {
                    if (Object.is(action, 'confirm') && localData && Object.keys(localData).length > 0) {
                        let targetItem: any = targetData.find((item: any) => {
                            return item.definitionkey === localData.processDefinitionKey;
                        })
                        openStartView(targetItem, localData);
                    }
                })
            } else {
                localData = { processDefinitionKey: targetData[0]['definitionkey'] }
                targetData[0]['process-view'] = "WFSTART@1";
                openStartView(targetData[0], localData);
            }
        })
    }