<#ibizinclude>
../../../@MACRO/LANG_FUN.ftl
</#ibizinclude>
<#--  后台界面行为  -->
<#if backend_block??>
${backend_block}
<#else>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
  <#if item.getgetPSAppDataEntity?? && item.getPSAppDataEntity()??>
     * @memberof ${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}UIService
  </#if>
     */
    public async ${item.getFullCodeName()}(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
    <#if item.render??>
        ${item.render.code}
    <#else>
      <#--  BEGIN: 自定义确认  -->
      <#if item.getConfirmMsg?? && item.getConfirmMsg()??>
        let confirmResult:boolean = await new Promise((resolve: any, reject: any) => {
          actionContext.$Modal.confirm({
              title: '警告',
              content: '${item.getConfirmMsg()}',
              onOk: () => {resolve(true);},
              onCancel: () => {resolve(false);}
          });
        });
        if(!confirmResult){
            return;
        }
      </#if>
      <#--  BEGIN: 自定义确认  -->
    <#if item.getActionTarget() == 'SINGLEDATA'>
        actionContext.$Notice.error({ title: '错误', desc: '不支持单项数据' });
    <#elseif item.getActionTarget() == 'MULTIDATA'>
        actionContext.$Notice.error({ title: '错误', desc: '不支持多项数据' });
    <#else>
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        <#if item.getPSNavigateContexts?? && item.getPSNavigateContexts()??>
        Object.assign(context,<@getNavigateContext item />);
        </#if>
        <#if item.getPSNavigateParams?? && item.getPSNavigateParams()??>
        Object.assign(params,<@getNavigateParams item />);
        </#if>
        <#-- 是否先保存目标数据start -->
        <#if item.isSaveTargetFirst()>
        const result:any = await xData.save(args,false);
        args = [result.data];
        </#if>
         <#-- 是否先保存目标数据end -->
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = <#if item.getActionTarget()??>'${item.getActionTarget()}'<#else>null</#if>;
    <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
    <#assign appDataEntity = item.getPSAppDataEntity() />
      <#if item.getActionTarget() == 'SINGLEKEY' || item.getActionTarget() == 'MULTIKEY'>
        <#assign valueItem><#if item.getValueItem?? && item.getValueItem() != ''>${item.getValueItem()}<#else>${appDataEntity.getKeyPSAppDEField().getCodeName()?lower_case}</#if></#assign>
        <#assign paramItem><#if item.getParamItem?? && item.getParamItem() != ''>${item.getParamItem()}<#else>${appDataEntity.getCodeName()?lower_case}</#if></#assign>
        <#assign textItem><#if item.getTextItem?? && item.getTextItem() != ''>${item.getTextItem()}<#else>${appDataEntity.getMajorPSAppDEField().getCodeName()?lower_case}</#if></#assign>
        Object.assign(context, { ${appDataEntity.getCodeName()?lower_case}: '%${paramItem}%' });
        Object.assign(params, { ${valueItem}: '%${paramItem}%' });
        Object.assign(params, { ${textItem}: '%${textItem}%' });
      </#if>
    </#if>
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        <#-- 多项数据主键转换数据 start -->
        if(Object.is(actionTarget,"MULTIKEY")){
            let tempDataArray:Array<any> = [];
            if((_args.length >1) && (Object.keys(data).length >0)){
                for(let i =0;i<_args.length;i++){
                    let tempObject:any = {};
                    Object.keys(data).forEach((key:string) =>{
                        Object.assign(tempObject,{[key]:data[key].split(',')[i]});
                    })
                    tempDataArray.push(tempObject);
                }
            }else{
                tempDataArray.push(data);
            }
            data = tempDataArray;
        }
        <#-- 多项数据主键转换数据 end -->
        context = Object.assign({},actionContext.context,context);
        <#-- 构建srfparentdename和srfparentkey start -->
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        <#-- 多项数据主键转换数据 start -->
        if(!Object.is(actionTarget,"MULTIKEY")){
            Object.assign(data,parentObj);
        }
        <#-- 多项数据主键转换数据 end -->
        Object.assign(context,parentObj);
        <#-- 构建srfparentdename和srfparentkey end -->
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
        <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()?? && item.getPSAppDEMethod?? && item.getPSAppDEMethod()??>
            const curService:${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}Service =  new ${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}Service();
            curService.${item.getPSAppDEMethod().getCodeName()}<#if item.getActionTarget() == 'MULTIKEY' && item.getPSDEAction?? && item.getPSDEAction()?? && item.getPSDEAction().getActionType?? && item.getPSDEAction().getActionType()?? && item.getPSDEAction().getActionType() =="USERCUSTOM">Batch</#if>(context,data, ${item.isShowBusyIndicator()?c}).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                <#if item.isShowBusyIndicator()>
                <#if item.getSuccessMsg?? && item.getSuccessMsg()??>
                actionContext.$Notice.success({ title: '成功', desc: '${item.getSuccessMsg()}' });
                <#else>
                actionContext.$Notice.success({ title: '成功', desc: '${item.getCaption()}成功！' });
                </#if>
                </#if>
                const _this: any = actionContext;
                <#--  是否重新加载数据  -->
                <#if item.isReloadData?? && item.isReloadData()>
                if (xData && xData.refresh && xData.refresh instanceof Function) {
                    xData.refresh(args);
                }
                </#if>
                <#-- 关闭编辑视图 -->
                <#if item.isCloseEditView()>
                actionContext.closeView(null);
                </#if>
                <#--  后续界面行为  -->
                <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                <#assign nextPSUIAction = item.getNextPSUIAction()/>
                const { data: result } = response;
                let _args: any[] = [];
                if (Object.is(actionContext.$util.typeOf(result), 'array')) {
                    _args = [...result];
                } else if (Object.is(actionContext.$util.typeOf(result), 'object')) {
                    _args = [{...result}];
                } else {
                    _args = [...args];
                }
                  <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                    _this.${nextPSUIAction.getFullCodeName()}(_args,context, params, $event, xData,actionContext);
                }
                  <#else>
                if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                    this.${nextPSUIAction.getFullCodeName()}(_args,context, params, $event, xData,actionContext);
                }
                  </#if>
                </#if>
                return response;
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        <#else>
            actionContext.$Notice.error({ title: '错误', desc: '模型异常，应用实体方法不存在' });
        </#if>
        };
      <#if item.getFrontPSAppView()??>
        <#assign frontview = item.getFrontPSAppView()>
        <#--  抽屉打开  -->
        <#if frontview.getOpenMode()?index_of('DRAWER') == 0>
        const view: any = {
            viewname: '${srffilepath2(frontview.getCodeName())}',
            title: actionContext.<@getViewLanguageTitle frontview />,
            height: ${frontview.getHeight()?c},
            width: ${frontview.getWidth()?c},
            placement: '${frontview.getOpenMode()}'
        };
        const appdrawer = actionContext.$appdrawer.openDrawer(view,context,data);
        appdrawer.subscribe((result: any) => {
            if (result && Object.is(result.ret, 'OK')) {
                Object.assign(data, { srfactionparam: result.datas });
                backend();
            }
        });
        <#--  模态打开  -->
        <#else>
        const view = { 
            viewname: '${srffilepath2(frontview.getCodeName())}', 
            title: actionContext.<@getViewLanguageTitle frontview />,
            height: ${frontview.getHeight()?c}, 
            width: ${frontview.getWidth()?c}, 
        };
        const appmodal = actionContext.$appmodal.openModal(view,context,data);
        appmodal.subscribe((result:any) => {
            if (result && Object.is(result.ret, 'OK')) {
                Object.assign(data, { srfactionparam: result.datas });
                backend();
            }
        });
        </#if>
      <#else>
        backend();
      </#if>
</#if>
</#if>
    }
</#if>