<#ibizinclude>
../../../@MACRO/LANG_FUN.ftl
</#ibizinclude>
<#--  前台界面行为  -->
<#if front_block??>
${front_block}
<#else>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
  <#if item.getgetPSAppDataEntity?? && item.getPSAppDataEntity()??>
     * @memberof ${srfclassname('${item.getPSAppDataEntity().getCodeName()}')}UIService
  </#if>
     */
    public async ${item.getFullCodeName()}(args: any[], context:any = {} ,params: any={}, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
    
    <#if item.render??>
        ${item.render.code}
    <#else>
  <#--  BEGIN: 数据目标: 单项数据  -->
  <#if item.getActionTarget() == 'SINGLEDATA'>
        actionContext.$Notice.error({ title: '错误', desc: '不支持单项数据' });
  <#--  END: 数据目标: 单项数据  -->
  <#--  BEGIN: 数据目标: 多项数据  -->
  <#elseif item.getActionTarget() == 'MULTIDATA'>
        actionContext.$Notice.error({ title: '错误', desc: '不支持多项数据' });
  <#--  END: 数据目标: 多项数据  -->
  <#--  BEGIN: 数据目标: 单项数据（主键），多项数据（主键），无数据  -->
  <#else>
    <#--  BEGIN: 数据处理逻辑  -->
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        <#if item.getPSNavigateContexts?? && item.getPSNavigateContexts()??>
        Object.assign(context,<@getNavigateContext item />);
        </#if>
        <#if item.getPSNavigateParams?? && item.getPSNavigateParams()??>
        Object.assign(params,<@getNavigateParams item />);
        </#if>
        <#-- 是否先保存目标数据start -->
        <#if item.isSaveTargetFirst()>
        const result:any = await xData.save(args,false);
        args = [result.data];
        </#if>
         <#-- 是否先保存目标数据end -->
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = <#if item.getActionTarget()??>'${item.getActionTarget()}'<#else>null</#if>;
    <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
    <#assign appDataEntity = item.getPSAppDataEntity() />
      <#if item.getActionTarget() == 'SINGLEKEY' || item.getActionTarget() == 'MULTIKEY'>
        <#assign valueItem><#if item.getValueItem?? && item.getValueItem() != ''>${item.getValueItem()}<#else>${appDataEntity.getKeyPSAppDEField().getCodeName()?lower_case}</#if></#assign>
        <#assign paramItem><#if item.getParamItem?? && item.getParamItem() != ''>${item.getParamItem()}<#else>${appDataEntity.getCodeName()?lower_case}</#if></#assign>
        <#assign textItem><#if item.getTextItem?? && item.getTextItem() != ''>${item.getTextItem()}<#else>${appDataEntity.getMajorPSAppDEField().getCodeName()?lower_case}</#if></#assign>
        Object.assign(context, { ${appDataEntity.getCodeName()?lower_case}: '%${paramItem}%' });
        Object.assign(params, { ${valueItem}: '%${paramItem}%' });
        Object.assign(params, { ${textItem}: '%${textItem}%' });
      </#if>
    </#if>
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        <#-- 构建srfparentdename和srfparentkey start -->
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        <#-- 构建srfparentdename和srfparentkey end -->
    <#--  END: 数据处理逻辑  -->
    <#--  BEGIN: 前台处理模式：打开HTML  -->
    <#if item.getFrontProcessType() == 'OPENHTMLPAGE'>
        <#--  打开独立程序弹出  -->
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
            return null;
        }
        const url = `${item.getHtmlPageUrl()}`;
        openPopupApp(url);
    <#--  END: 前台处理模式：打开HTML  -->
    <#--  BEGIN: 前台处理模式：打开顶级视图，打开顶级视图或向导（模态）  -->
    <#elseif (item.getFrontProcessType() == 'TOP' || item.getFrontProcessType() == 'WIZARD') && item.getFrontPSAppView()??>
      <#assign dataview = item.getFrontPSAppView()>
      <#--  BEGIN：准备参数  -->
      <#if dataview.isRedirectView()>
        const deResParameters: any[] = [];
        const parameters: any[] = [];
      <#else>
        <#--  BEGIN：是否应用实体视图  -->
        <#if dataview.isPSDEView()>
        <#-- 存在关系start -->
        <#if dataview.getPSAppDERSPathCount() gt 0>
        <#list 1..dataview.getPSAppDERSPathCount() as count>
        <#assign condition = ''/>
        <#list dataview.getPSAppDERSPath(count_index)  as deRSPath>
            <#if deRSPath.getMajorPSAppDataEntity?? && deRSPath.getMajorPSAppDataEntity()??>
                <#assign _dataEntity = deRSPath.getMajorPSAppDataEntity()/>
                <#assign condition>${condition}context.${_dataEntity.getCodeName()?lower_case} && </#assign>
            </#if>
        </#list>
        </#list>
        let deResParameters: any[] = [];
        <#-- 如果是主实体需对context判断start -->
        <#if dataview.getPSAppDataEntity().isMajor()>
        if(${condition}true){
            deResParameters = [
            <#list dataview.getPSAppDERSPath(dataview.getPSAppDERSPathCount() - 1) as deRSPath>
            <#assign majorPSAppDataEntity = deRSPath.getMajorPSAppDataEntity()/>
            { pathName: '${srfpluralize(majorPSAppDataEntity.codeName)?lower_case}', parameterName: '${majorPSAppDataEntity.getCodeName()?lower_case}' },
            </#list>
            ]
        }
        <#else>
        deResParameters = [
            <#list dataview.getPSAppDERSPath(dataview.getPSAppDERSPathCount() - 1) as deRSPath>
            <#assign majorPSAppDataEntity = deRSPath.getMajorPSAppDataEntity()/>
            { pathName: '${srfpluralize(majorPSAppDataEntity.codeName)?lower_case}', parameterName: '${majorPSAppDataEntity.getCodeName()?lower_case}' },
            </#list>
        ];
        </#if>
        <#-- 如果是主实体需对context判断end -->
        <#else>
        let deResParameters: any[] = [];
        </#if>
        <#-- 存在关系end -->
        <#else>
        const deResParameters: any[] = [];
        </#if>
        <#--  END：是否应用实体视图  -->
        <#if dataview.getOpenMode() == 'INDEXVIEWTAB' || dataview.getOpenMode() == ''>
          <#--  BEGIN：是否应用实体视图  -->
          <#if dataview.isPSDEView()>
          <#assign appDataEntity = dataview.getPSAppDataEntity()/>
        const parameters: any[] = [
            { pathName: '${srfpluralize(appDataEntity.codeName)?lower_case}', parameterName: '${appDataEntity.getCodeName()?lower_case}' },
            { pathName: '${dataview.getPSDEViewCodeName()?lower_case}', parameterName: '${dataview.getPSDEViewCodeName()?lower_case}' },
        ];
          <#else>
        const parameters: any[] = [
            { pathName: '${dataview.getCodeName()?lower_case}', parameterName: '${dataview.getCodeName()?lower_case}' },
        ];
          </#if>
          <#--  END：是否应用实体视图  -->
        <#else>
          <#--  BEGIN：是否应用实体视图  -->
          <#if dataview.isPSDEView()>
          <#assign appDataEntity = dataview.getPSAppDataEntity()/>
        const parameters: any[] = [
            { pathName: '${srfpluralize(appDataEntity.codeName)?lower_case}', parameterName: '${appDataEntity.getCodeName()?lower_case}' },
        ];
          <#else>
        const parameters: any[] = [];
          </#if>
          <#--  END：是否应用实体视图  -->
        </#if>
      </#if>
      <#--  END：准备参数  -->
      <#--  BEGIN: 打开重定向视图  -->
      <#if dataview.isRedirectView()>
        <#-- BEGIN: 打开顶级分页视图  -->
            // 打开顶级分页视图
            const openIndexViewTab = (viewpath: string, data: any) => {
                const _params = actionContext.$util.prepareRouteParmas({
                    route: actionContext.$route,
                    sourceNode: actionContext.$route.name,
                    targetNode: viewpath,
                    data: data,
                });
                actionContext.$router.push({ name: viewpath, params: _params });
                <#--  是否重新加载数据  -->
                <#if item.isReloadData?? && item.isReloadData()>
                if (xData && xData.refresh && xData.refresh instanceof Function) {
                    xData.refresh(args);
                }
                </#if>
                <#--  后续界面行为  -->
                <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                <#assign nextPSUIAction = item.getNextPSUIAction()/>
                  <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                    _this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                }
                  <#else>
                if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                    this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                }
                  </#if>
                </#if>
                return null;
            }
        <#-- END: 打开顶级分页视图  -->
        <#-- BEGIN: 打开模态  -->
            // 打开模态
            const openPopupModal = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$appmodal.openModal(view,context,data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = actionContext;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                      <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      <#else>
                    if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      </#if>
                    </#if>
                    return result.datas;
                });
            }
        <#-- END: 打开模态  -->
        <#-- BEGIN: 打开抽屉  -->
            // 打开抽屉
            const openDrawer = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$appdrawer.openDrawer(view,context, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = actionContext;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                      <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      <#else>
                    if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      </#if>
                    </#if>
                    return result.datas;
                });
            }
        <#-- END: 打开抽屉  -->
        <#-- BEGIN: 打开气泡卡片  -->
            // 打开气泡卡片
            const openPopOver = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$apppopover.openPop($event, view,context, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = actionContext;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                      <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      <#else>
                    if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      </#if>
                    </#if>
                    return result.datas;
                });
            }
        <#-- END: 打开气泡卡片  -->
        <#-- BEGIN: 打开独立程序弹出  -->
            // 打开独立程序弹出 
            const openPopupApp = (url: string) => {
                window.open(url, '_blank');
                return null;
            }
        <#assign dataview_de = dataview.getPSAppDataEntity().getPSDataEntity()/>
            const url: string = '/${app.getPKGCodeName()?lower_case}/${dataview_de.getPSSystemModule().codeName?lower_case}/${dataview_de.codeName?lower_case}/${dataview.getPSDEViewCodeName()?lower_case}/getmodel';
            actionContext.$http.get(url, data).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: '请求异常' });
                }
                if (response.status === 401) {
                    return;
                }
                const { data: result } = response;
                if (!result) {
                    return reject(response);
                }

                if (result.viewparams && Object.keys(result.viewparams)) {
                    Object.assign(data, result.viewparams);
                }

                if (Object.is(result.openmode, 'POPUPAPP') && result.url && !Object.is(result.url, '')) {
                    openPopupApp(result.url);
                } else if (Object.is(result.openmode, 'INDEXVIEWTAB') || Object.is(result.openmode, '')) {
                    const viewpath = ${r'`${result.viewmodule}_${result.viewname}`.toLowerCase()'};
                    openIndexViewTab(viewpath, data);
                } else if (Object.is(result.openmode, 'POPUPMODAL')) {
                    const viewname = actionContext.$util.srfFilePath2(result.viewname);
                    const view: any = {
                        viewname: viewname,
                        title: result.title,
                        width: result.width,
                        height: result.height,
                    }
                    openPopupModal(view,context,data);
                } else if (result.openmode.startsWith('DRAWER')) {
                    const viewname = actionContext.$util.srfFilePath2(result.viewname);
                    const view: any = {
                        viewname: viewname,
                        title: result.title,
                        width: result.width,
                        height: result.height,
                        placement: result.openmode,
                    }
                    openDrawer(view,context,data);
                } else if (Object.is(result.openmode, 'POPOVER')) {
                    const viewname = actionContext.$util.srfFilePath2(result.viewname);
                    const view: any = {
                        viewname: viewname,
                        title: result.title,
                        width: result.width,
                        height: result.height,
                        placement: result.openmode,
                    }
                    openPopOver(view,context,data);
                }  
            }).catch((response: any) => {
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: '错误', desc: '系统异常！' });
                    return;
                }
                if (response.status === 401) {
                    return;
                }
            })
        <#-- END: 打开独立程序弹出  -->
      <#--  END: 打开重定向视图  -->
      <#--  BEGIN: 打开顶级分页视图  -->
      <#elseif dataview.getOpenMode() =='INDEXVIEWTAB' || dataview.getOpenMode() == ''>
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            <#--  BEGIN 是否重新加载数据  -->
            <#if item.isReloadData?? && item.isReloadData()>
            if (xData && xData.refresh && xData.refresh instanceof Function) {
                xData.refresh(args);
            }
            </#if>
            <#--  END 是否重新加载数据  -->
            <#-- BEGIN关闭编辑视图 -->
            <#if item.isCloseEditView()>
            actionContext.closeView(null);
            </#if>
            <#-- END关闭编辑视图 -->
            <#--  BEGIN 后续界面行为  -->
            <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
            <#assign nextPSUIAction = item.getNextPSUIAction()/>
              <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
            if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                _this.${nextPSUIAction.getFullCodeName()}([data],context,params, $event, xData,actionContext);
            }
              <#else>
            if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                this.${nextPSUIAction.getFullCodeName()}([data],context,params, $event, xData,actionContext);
            }
              </#if>
            </#if>
            <#--  END 后续界面行为  -->
            return null;
        }
        openIndexViewTab(data);
      <#--  END: 打开顶级分页视图  -->
      <#-- BEGIN: 打开模态  -->
      <#elseif dataview.getOpenMode() = 'POPUPMODAL'>
            const openPopupModal = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$appmodal.openModal(view, context, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = actionContext;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    }
                    </#if>
                    <#-- BEGIN关闭编辑视图 -->
                    <#if item.isCloseEditView()>
                    _this.closeView(null);
                    </#if>
                    <#-- END关闭编辑视图 -->
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                      <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas,context, params, $event, xData,actionContext);
                    }
                      <#else>
                    if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        this.${nextPSUIAction.getFullCodeName()}(result.datas,context, params, $event, xData,actionContext);
                    }
                      </#if>
                    </#if>
                    <#--  if(window.opener){
                        window.opener.postMessage({status:'OK',identification:'WF'},Environment.uniteAddress);
                        window.close();
                    }  -->
                    return result.datas;
                });
            }
            const view: any = {
                viewname: '${srffilepath2(dataview.getCodeName())}', 
                height: ${dataview.getHeight()?c}, 
                width: ${dataview.getWidth()?c},  
                title: actionContext.<@getViewLanguageTitle dataview />,
            };
            openPopupModal(view, data);
      <#-- END: 打开模态  -->
      <#--  BEGIN: 打开抽屉  -->
      <#elseif dataview.getOpenMode()?index_of('DRAWER') == 0>
            const openDrawer = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$appdrawer.openDrawer(view, context,data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = actionContext;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    }
                    </#if>
                    <#-- BEGIN关闭编辑视图 -->
                    <#if item.isCloseEditView()>
                    _this.closeView(null);
                    </#if>
                    <#-- END关闭编辑视图 -->
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                      <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      <#else>
                    if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        this.${nextPSUIAction.getFullCodeName()}(result.datas,context,params, $event, xData,actionContext);
                    }
                      </#if>
                    </#if>
                    <#--  if(window.opener){
                        window.opener.postMessage({status:'OK',identification:'WF'},Environment.uniteAddress);
                        window.close();
                    }  -->
                    return result.datas;
                });
            }
            const view: any = {
                viewname: '${srffilepath2(dataview.getCodeName())}', 
                height: ${dataview.getHeight()?c}, 
                width: ${dataview.getWidth()?c},  
                title: actionContext.<@getViewLanguageTitle dataview />,
                placement: '${dataview.getOpenMode()}',
            };
            openDrawer(view, data);
      <#--  END: 打开抽屉  -->
      <#--  BEGIN: 打开气泡卡片  -->
      <#elseif dataview.getOpenMode() == 'POPOVER'>
            const openPopOver = (view: any, data: any) => {
                let container: Subject<any> = actionContext.$apppopover.openPop($event, view, context,data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = actionContext;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    }
                    </#if>
                    <#-- BEGIN关闭编辑视图 -->
                    <#if item.isCloseEditView()>
                    _this.closeView(null);
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                      <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas,context, params, $event, xData,actionContext);
                    }
                      <#else>
                    if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        this.${nextPSUIAction.getFullCodeName()}(result.datas,context, params, $event, xData,actionContext);
                    }
                      </#if>
                    </#if>
                    <#--  if(window.opener){
                        window.opener.postMessage({status:'OK',identification:'WF'},Environment.uniteAddress);
                        window.close();
                    }  -->
                    return result.datas;
                });
            }
            const view: any = {
                viewname: '${srffilepath2(dataview.getCodeName())}', 
                height: ${dataview.getHeight()?c}, 
                width: ${dataview.getWidth()?c},  
                title: actionContext.<@getViewLanguageTitle dataview />,
                placement: '${dataview.getOpenMode()}',
            };
            openPopOver(view, data);
      <#--  END: 打开气泡卡片  -->
      <#--  BEGIN: 其他打开模式  -->
      <#else>
            actionContext.$Notice.warning({ title: '错误', desc: actionContext.<@getViewLanguageTitle dataview />+'不支持该模式打开' });
      </#if>
      <#--  END: 其他打开模式  -->
    <#--  END: 前台处理模式：打开顶级视图，打开顶级视图或向导（模态）  -->
    <#--  BEGIN: 前台处理模式：用户自定义  -->
    <#elseif item.getFrontProcessType() == 'OTHER'>
        <#--  是否重新加载数据  -->
        <#if item.isReloadData?? && item.isReloadData()>  
              if (xData && xData.refresh && xData.refresh instanceof Function) {
                  xData.refresh(args);
              }
            <#-- 关闭编辑视图 -->
            <#if item.isCloseEditView()>
            actionContext.closeView(null);
            </#if>
            <#--  后续界面行为  -->
            <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
            <#assign nextPSUIAction = item.getNextPSUIAction()/>
              <#if !(nextPSUIAction.getPSAppDataEntity?? && nextPSUIAction.getPSAppDataEntity()??)>
              if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                  _this.${nextPSUIAction.getFullCodeName()}(result.datas,context, params, $event, xData,actionContext);
              }
              <#else>
              if (this.${nextPSUIAction.getFullCodeName()} && this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                  this.${nextPSUIAction.getFullCodeName()}(result.datas,context, params, $event, xData,actionContext);
              }
              </#if>
            </#if>
        <#else>
            // 自定义实体界面行为
            actionContext.$Notice.warning({ title: '错误', desc: '${item.getCaption()} 未实现' });
        </#if>

    </#if>
    <#--  END: 前台处理模式：用户自定义  -->
  </#if>
  <#--  END: 数据目标: 单项数据（主键），多项数据（主键），无数据  -->
  </#if>
    }
</#if>
    