<#ibizinclude>
./WF_VIEW_CONTENT.vue.ftl
</#ibizinclude>

    <#if view.getPSAppViewEngines()??>
    <#list view.getPSAppViewEngines() as engine>
    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${engine.getName()?lower_case}: ${engine.getEngineType()}Engine = new ${engine.getEngineType()}Engine();
    </#list>
    </#if>

    /**
     * 引擎初始化
     *
     * @public
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public engineInit(): void {
    <#if view.getPSAppViewEngines()??>
    <#list view.getPSAppViewEngines() as engine>
        this.${engine.getName()?lower_case}.init({
            view: this,
        <#if engine.getPSAppViewEngineParams()??>
            <#list engine.getPSAppViewEngineParams() as param>
            <#if param.getParamType() == "LOGIC" && param.getPSAppViewLogic()??>
            ${param.getName()?lower_case}: (args: any[], params?: any, $event?: any, xData?: any) => {
                this.${param.getPSAppViewLogic().getName()}(args, params, $event, xData);
            },
            </#if>
            <#if param.getParamType() == "CTRL" && param.getPSControl()??>
            ${param.getName()?lower_case}: this.$refs.${param.getPSControl().getName()},
            </#if>
            <#if param.getParamType() == "VALUE" && param.getValue()??>
            ${param.getName()?lower_case}: '${param.getValue()?c}',
            </#if>
            </#list>
        </#if>
        <#if de??>
            keyPSDEField: '${de.getCodeName()?lower_case}',
            <#if de.getMajorPSDEField()??>
            majorPSDEField: '${de.getMajorPSDEField().getCodeName()?lower_case}',
            </#if>
        </#if>
            isLoadDefault: <#if view.isLoadDefault?? && !view.isLoadDefault()>false<#else>true</#if>,
        });
    </#list>
    </#if>
    }

    /**
     * 应用上下文
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public context:any = {};

    /**
     * 视图参数
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public viewparams:any = {};

    /**
     * 解析视图参数
     *
     * @public
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public parseViewParam(): void {
        if (!this.viewDefaultUsage && this.viewdata && !Object.is(this.viewdata, '')) {
            Object.assign(this.context, JSON.parse(this.viewdata));
            <#if self_viewparam??>
            ${self_viewparam}
            </#if>
            return;
        }
        const path = (this.$route.matched[this.$route.matched.length - 1]).path;
        const keys: Array<any> = [];
        const curReg = this.$pathToRegExp.pathToRegexp(path, keys);
        const matchArray = curReg.exec(this.$route.path);
        let tempValue: Object = {};
        keys.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item.name, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
        this.$viewTool.formatRouteParams(tempValue,this.$route,this.context,this.viewparams);
        <#if view.isPSDEView()>
        //初始化视图唯一标识
        Object.assign(this.context,{srfsessionid:this.$util.createUUID()});
        </#if>
    }

    /**
     * Vue声明周期
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public created() {
        this.afterCreated();
    }

    /**
     * 执行created后的逻辑
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */    
    public afterCreated(){
        const secondtag = this.$util.createUUID();
        this.$store.commit('viewaction/createdView', { viewtag: this.viewtag, secondtag: secondtag });
        this.viewtag = secondtag;
        this.parseViewParam();
        <#if created_block??>${created_block}</#if>
    }

    /**
     * 销毁之前
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public beforeDestroy() {
        this.$store.commit('viewaction/removeView', this.viewtag);
    }

    /**
     * Vue声明周期(组件初始化完毕)
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public mounted() {
        this.afterMounted();
    }

    /**
     * 执行mounted后的逻辑
     * 
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public afterMounted(){

        <#if view.getPSControls()??>
        <#list view.getPSControls() as ctrl>
        this.viewState.next({tag: '${ctrl.name}', action: 'load', data: {}});
        </#list>
        </#if>
        
    }

    <#if view.getPSControls()??>
    <#list view.getPSControls() as ctrl>
    <#if ctrl.getControlType()??>
    <#if ctrl.getHookEventNames()??>
    <#list ctrl.getHookEventNames() as eventName>

    /**
     * ${ctrl.name} 部件 ${eventName?lower_case} 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${ctrl.name}_${eventName?lower_case}($event: any, $event2?: any) {
    <#if ctrl.getPSControlLogics(eventName)??>
    <#list ctrl.getPSControlLogics(eventName) as ctrlLogic>
    <#if ctrlLogic.getLogicType() == "APPVIEWENGINE" && ctrlLogic.getPSAppViewEngine()??>
        this.${ctrlLogic.getPSAppViewEngine().getName()}.onCtrlEvent('${ctrl.name}', '${eventName?lower_case}', $event);
    <#else>
        <#if ctrlLogic.getEventArg()?? && ctrlLogic.getEventArg()?length gt 0>
        if (Object.is($event.tag, '${ctrlLogic.getEventArg()}')) {
            this.${ctrlLogic.name}($event, '', $event2);
        }
        <#else>
        this.${ctrlLogic.name}($event, '', $event2);
        </#if>
    </#if>
    </#list>
    </#if>
    }

    </#list>
    </#if>
    </#if>
    </#list>
    </#if>

<#if view.getPSAppViewLogics()??>
<#list view.getPSAppViewLogics() as logic>
<#if logic.getLogicTrigger() == "CUSTOM" || logic.getLogicTrigger() == "CTRLEVENT">

${P.getLogicCode(logic, "LOGIC.vue").code}
</#if>
</#list>
</#if>

<#if view.getPSUIActions()??>
<#list view.getPSUIActions() as uiAction>
<#-- 系统预置界面行为输入start -->
<#if !(uiAction.getPSAppDataEntity?? && uiAction.getPSAppDataEntity()??)>
${P.getLogicCode(uiAction, "LOGIC.vue").code}
</#if>
<#-- 系统预置界面行为输入end -->
</#list>
</#if>

    /**
     * 关闭视图
     *
     * @param {any[]} args
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public closeView(args: any[]): void {
        let _view: any = this;
        if (_view.viewdata) {
            _view.$emit('viewdataschange', [args]);
            _view.$emit('close', [args]);
        } else if (_view.$tabPageExp) {
            _view.$tabPageExp.onClose(_view.$route.fullPath);
        }
    }
    <#if view.isPSDEView()>
    <#if view.getPSAppDataEntity()??>
    <#assign appDataEntity = view.getPSAppDataEntity() />
    <#if appDataEntity.isMajor()>

    /**
     * 销毁视图回调
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public destroyed(){
        this.afterDestroyed();
    }

    /**
     * 执行destroyed后的逻辑
     * 
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public afterDestroyed(){
        if(this.viewDefaultUsage){
            let localStoreLength = Object.keys(localStorage);
            if(localStoreLength.length > 0){
                localStoreLength.forEach((item:string) =>{
                if(item.startsWith(this.context.srfsessionid)){
                    localStorage.removeItem(item);
                }
                })
            }
        }
    }
    </#if>
    </#if>
    </#if>
    <#--  视图独立定义的内容start  -->
    <#if self_content??>
    ${self_content}
    </#if>
    <#--  视图独立定义的内容end  -->