<#--  重置数据  -->
<#macro dataCancelChanges item>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} contextJO 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName]  父实体名称
     */
    public ${item.getFullCodeName()}(args: any[], contextJO?:any, params?: any, $event?: any, xData?: any, actionContext?:any, srfParentDeName?:string) {
        if (actionContext.viewType === 'APPLOGINVIEW') {
            const length = Object.keys(actionContext.layoutData).length;
            for (let i = length - 1; i >= 0; i--) {
                const name = Object.keys(actionContext.layoutData)[i];
                if (actionContext.layoutData.hasOwnProperty(name) && !Object.is(actionContext.layoutModelDetails[name].itemType, 'CONTAINER')) {
                    actionContext.handleValueChange({ name, value: null });
                }
            }
            actionContext.$nextTick(() => {
                actionContext.$forceUpdate();
            })
        } else {
            const parentRef: any = actionContext.$parent;
            if (parentRef.closeView && (parentRef.closeView instanceof Function)) {
                parentRef.closeView(args);
            } else if (actionContext.closeView && (actionContext.closeView instanceof Function)) {
                actionContext.closeView(args);
            }
        }
    }
</#macro>