<#--  删除数据  -->
<#macro dataRemoveObject item>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName]  父实体名称
     */
    public async ${item.getFullCodeName()}(args: any[], context: any = {}, params: any = {}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?: string) {
        <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()??>
        // 准备上下文参数
        const tempContext = {...context};
        if (xData && xData.context) {
            Object.assign(tempContext, xData.context);
        }
        const data = args[0];
        const service = await window.entityServiceRegister.getService('${item.getPSAppDataEntity().getCodeName()?lower_case}');
        if (service) {
            const key = service.APPDEKEY.toLowerCase();
            const name = service.APPDENAME.toLowerCase();
            if (data.hasOwnProperty(name)) {
                Object.assign(tempContext, { [name]: data[name] });
            }
            if (data.hasOwnProperty(key)) {
                Object.assign(tempContext, { [name]: data[key] });
            }
            try {
                service.Remove(tempContext, data).then((response: any) => {
                    if (!response.status || response.status !== 200) {
                        this.$Notice.error({ title: '错误', desc: '当前环境无法执行删除数据逻辑[执行行为异常]' });
                    }
                })
            } catch (error: any) {
                this.$Notice.error({ title: '错误', desc: '当前环境无法执行删除数据逻辑[执行行为异常]' });
            }
        }
        <#else>
        this.$Notice.error({ title: '错误', desc: '删除数据行未配置实体' });
        </#if>
    }
</#macro>