<#--  登出  -->
<#macro logout item>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} contextJO 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName]  父实体名称
     */
    public ${item.getFullCodeName()}(args: any[], contextJO?:any, params?: any, $event?: any, xData?: any, actionContext?:any, srfParentDeName?:string) {
        this.$Modal.confirm({
            title: '提示',
            content: '确认要退出登录？',
            okText: '确认',
            cancelText: '取消',
            onOk: () => {
                this.$http
                .get("/v7/logout")
                .then((response: any) => {
                    if (response && response.status === 200) {
                        localStorage.removeItem("user");
                        localStorage.removeItem("token");
                        let leftTime = new Date();
                        leftTime.setTime(leftTime.getSeconds() - 1);
                        document.cookie = "ibzuaa-token=;expires=" + leftTime.toUTCString();
                        this.$router.push({ path: "/login", query: { redirect: window.location.hash.replace("#", '') } });
                    }
                })
                .catch((error: any) => {
                    console.error(error);
                });
            }
        });
    }
</#macro>