<#--  同步数据  -->
<#macro dataSynchronize item>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName]  父实体名称
     */
    public ${item.getFullCodeName()}(args: any[], context: any = {}, params: any = {}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?: string) {
        if (xData) {
            if (xData.refresh && (xData.refresh instanceof Function)) {
                xData.refresh();
            } else if (xData.refreshDataArea && (xData.refreshDataArea instanceof Function)) {
                xData.refreshDataArea();
            } else {
                this.$Notice.error({ title: '错误', desc: '同步数据行为未实现' });
            }
        }
    }
</#macro>