<#--  登录  -->
<#macro login item>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} args 当前数据
     * @param {any} contextJO 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName]  父实体名称
     */
    public ${item.getFullCodeName()}(args: any[], contextJO?:any, params?: any, $event?: any, xData?: any, actionContext?:any, srfParentDeName?:string) {
        if (actionContext.viewType === 'APPLOGINVIEW') {
            const layoutData = args.length > 0 ? args[0] : {};
            const layoutModelDetails: any = actionContext.layoutModelDetails || {};
            let userNameKey: string = Object.keys(layoutModelDetails).find((key: string) => Object.is(layoutModelDetails[key].predefinedType, 'AUTH_USERID')) || '';
            let passwordKey: string = Object.keys(layoutModelDetails).find((key: string) => Object.is(layoutModelDetails[key].predefinedType, 'AUTH_PASSWORD')) || '';
            let messageKey: string = Object.keys(layoutModelDetails).find((key: string) => Object.is(layoutModelDetails[key].predefinedType, 'AUTH_LOGINMSG')) || '';
            if (!userNameKey || !passwordKey) {
                if (messageKey) {
                    actionContext.handleValueChange({ name: messageKey, value: '用户名或密码未配置！' });
                } else {
                    actionContext.$message({ message: '用户名或密码未配置！',type: 'warning'});
                }
                return;
            }
            const loginname: any = layoutData[userNameKey];
            const password: any = layoutData[passwordKey];
            if (!loginname || !password) {
                if (messageKey) {
                    actionContext.handleValueChange({ name: messageKey, value: '请输入用户名与密码' });
                } else {
                    actionContext.$message({ message: '请输入用户名与密码',type: 'warning'});
                }
                return;
            }
            // 清除cookie
            let leftTime = new Date();
            leftTime.setTime(leftTime.getSeconds() - 1000);
            document.cookie = "ibzuaa-token=;expires=" + leftTime.toUTCString();
            const data = { loginname, password };
            const post: Promise<any> = actionContext.$http.post('/v7/login', data, true);
            post.then((response: any) => {
                if (response && response.status === 200) {
                    const data = response.data;
                    if (data && data.token) {
                        localStorage.setItem('token', data.token);
                        Util.setCookie('ibzuaa-token',data.token,0);
                    }
                    if(data && data.user){
                        localStorage.setItem('user', JSON.stringify(data.user));
                    }
                    // 设置cookie,保存账号密码7天
                    Util.setCookie("loginname",loginname, 7);
                    // 跳转首页
                    const url: any = actionContext.$route.query.redirect ? actionContext.$route.query.redirect : '*';
                    actionContext.$router.push({path: url});
                }
            }).catch((error: any) => {
                // 登录提示
                const data = error.data;
                if (data) {
                    if (messageKey) {
                        actionContext.handleValueChange({ name: messageKey, value: data.message || this.$t('components.login.loginfailed') });
                    }
                }
            });
        } else {
            actionContext.$router.push({ path: "/login", query: { redirect: window.location.hash.replace("#", '') } });
        }
    }
</#macro>