<script lang='tsx'>
import { Vue, Component, Prop, Provide, Emit, Watch, Model,Inject } from 'vue-property-decorator';
import { CreateElement } from 'vue';
import { Subject, Subscription } from 'rxjs';
import { ControlInterface } from '@/interface/control';
import { UIActionTool,Util, ViewTool } from '@/utils';
import NavDataService from '@/service/app/navdata-service';
<#if ctrl.getPSAppCounterRefs?? && ctrl.getPSAppCounterRefs()??>
<#list ctrl.getPSAppCounterRefs() as singleCounterRef>
<#if singleCounterRef.getPSAppCounter()??>
<#assign appCounter = singleCounterRef.getPSAppCounter()/>
import  ${srfclassname('${appCounter.getCodeName()}')}CounterService  from '@/counter/${srffilepath2(appCounter.getCodeName())}/${srffilepath2(appCounter.getCodeName())}-counter';
</#if>
</#list>
</#if>
<#if appde??>
import ${srfclassname('${appde.getCodeName()}')}Service from '@/service/${srffilepath2(appde.getCodeName())}/${srffilepath2(appde.getCodeName())}-service';
</#if>
import ${srfclassname('${ctrl.codeName}')}Service from './${srffilepath2(ctrl.codeName)}-${ctrl.getControlType()?lower_case}-service';

<#if ctrl.getPSUIActions?? && ctrl.getPSUIActions()??>
<#list ctrl.getPSUIActions() as uiAction>
<#if uiAction.getPSAppDataEntity()??>
<#assign curAppEntity = uiAction.getPSAppDataEntity()/>
<#if !P.exists("importService", curAppEntity.getId(), "") >
import ${srfclassname('${curAppEntity.getCodeName()}')}UIService from '@/uiservice/${srffilepath2(curAppEntity.getCodeName())}/${srffilepath2(curAppEntity.getCodeName())}-ui-service';
<#if appde?? && (curAppEntity.getId() == appde.getId())><#assign hasAppDE = true /></#if>
</#if>
</#if>
</#list>
</#if>
<#if appde?? && !hasAppDE??>
import ${srfclassname('${appde.getCodeName()}')}UIService from '@/uiservice/${srffilepath2(appde.getCodeName())}/${srffilepath2(appde.getCodeName())}-ui-service';
</#if>
<#--  语言资源入口  -->
<#ibizinclude>
./LANGBASE.vue.ftl
</#ibizinclude>
<#if import_block??>${import_block}</#if>

@Component({
    components: {
      <#if component_block??>${component_block}</#if>
    }
})
export default class <#if ctrl.getPSAppDataEntity()??>${srfclassname('${ctrl.getPSAppDataEntity().getCodeName()}')}</#if>${srfclassname('${ctrl.codeName}')}Base extends Vue implements ControlInterface {

    /**
     * 名称
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    @Prop() public name?: string;

    /**
     * 视图通讯对象
     *
     * @type {Subject<ViewState>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    @Prop() public viewState!: Subject<ViewState>;

    /**
     * 应用上下文
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    @Prop() public context!: any;

    /**
     * 视图参数
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    @Prop() public viewparams!: any;

    /**
     * 视图操作参数
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    @Prop() public viewCtx!: any;

    /**
     * 视图状态事件
     *
     * @public
     * @type {(Subscription | undefined)}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public viewStateEvent: Subscription | undefined;

    /**
     * 获取部件类型
     *
     * @returns {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public getControlType(): string {
        return '${ctrl.getControlType()}'
    }


<#if ctrl.getPSAppCounterRefs?? && ctrl.getPSAppCounterRefs()??>
<#assign counterRefs = ''/>
<#list ctrl.getPSAppCounterRefs() as singleCounterRef>
<#if singleCounterRef.getPSAppCounter()??>
<#assign appCounter = singleCounterRef.getPSAppCounter()/>
    <#assign counterRefs>${counterRefs}this.${appCounter.getCodeName()?lower_case}counterservice<#if singleCounterRef_has_next>,</#if></#assign>
    
    /**
     * ${srfclassname('${appCounter.getCodeName()}')}CounterService计数器服务对象
     *
     * @type {${srfclassname('${appCounter.getCodeName()}')}CounterService}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public ${appCounter.getCodeName()?lower_case}counterservice: ${srfclassname('${appCounter.getCodeName()}')}CounterService = new ${srfclassname('${appCounter.getCodeName()}')}CounterService({context:this.context,viewparams:this.viewparams});
</#if>
</#list>

    /**
     * 计数器服务对象集合
     *
     * @type {Array<*>}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */    
    public counterServiceArray:Array<any> = [${counterRefs}];
</#if>

    /**
     * 建构部件服务对象
     *
     * @type {${srfclassname('${ctrl.codeName}')}Service}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public service: ${srfclassname('${ctrl.codeName}')}Service = new ${srfclassname('${ctrl.codeName}')}Service({ $store: this.$store });
<#if appde??>

    /**
     * 实体服务对象
     *
     * @type {${srfclassname('${appde.getCodeName()}')}Service}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public appEntityService: ${srfclassname('${appde.getCodeName()}')}Service = new ${srfclassname('${appde.getCodeName()}')}Service({ $store: this.$store });

    /**
     * 界面UI服务对象
     *
     * @type {${srfclassname('${appde.getCodeName()}')}UIService}
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */  
    public appUIService:${srfclassname('${appde.getCodeName()}')}UIService = new ${srfclassname('${appde.getCodeName()}')}UIService();
</#if>
    <#if ctrl.getPSControls?? && ctrl.getPSControls()??>
    <#list ctrl.getPSControls() as childCtrl>
    <#if childCtrl.getControlType()??>
    <#if childCtrl.getHookEventNames()??>
    <#list childCtrl.getHookEventNames() as eventName>

    /**
     * ${childCtrl.name} 部件 ${eventName?lower_case} 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public ${childCtrl.name}_${eventName?lower_case}($event: any, $event2?: any) {
    <#if childCtrl.getPSControlLogics(eventName)??>
    <#list childCtrl.getPSControlLogics(eventName) as ctrlLogic>
    <#if ctrlLogic.getLogicType?? && ctrlLogic.getLogicType() == "APPVIEWENGINE" && ctrlLogic.getPSAppViewEngine()??>
        this.${ctrlLogic.getPSAppViewEngine().getName()}.onCtrlEvent('${childCtrl.name}', '${eventName?lower_case}', $event);
    <#else>
        <#if ctrlLogic.getEventArg()?? && ctrlLogic.getEventArg()?length gt 0>
        if (Object.is($event.tag, '${ctrlLogic.getEventArg()}')) {
            this.${ctrlLogic.name}(null, '<#if ctrlLogic.getLogicTag()?length gt 0>${ctrlLogic.getLogicTag()}</#if>', $event2);
        }
        <#else>
        this.${ctrlLogic.name}($event, '<#if ctrlLogic.getLogicTag()?length gt 0>${ctrlLogic.getLogicTag()}</#if>', $event2);
        </#if>
    </#if>
    </#list>
    </#if>
    }
    </#list>
    </#if>
    </#if>
    </#list>
    </#if>
    
<#if ctrl.getPSAppViewLogics?? && ctrl.getPSAppViewLogics()??>
<#list ctrl.getPSAppViewLogics() as logic>
<#if logic.getLogicTrigger() == "CUSTOM" || logic.getLogicTrigger() == "CTRLEVENT">

${P.getLogicCode(logic, "LOGIC.vue").code}
</#if>
</#list>
</#if>

<#if ctrl.getPSUIActions?? && ctrl.getPSUIActions()??>
<#list ctrl.getPSUIActions() as uiAction>
<#if !uiAction.getPSAppDataEntity()??>
${P.getLogicCode(uiAction, "LOGIC.vue").code}
</#if>
</#list>
</#if>

    /**
     * 关闭视图
     *
     * @param {any} args
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public closeView(args: any): void {
        let _this: any = this;
        _this.$emit('closeview', [args]);
    }

    /**
     *  计数器刷新
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}Base
     */
    public counterRefresh(){
        const _this:any =this;
        if(_this.counterServiceArray && _this.counterServiceArray.length >0){
            _this.counterServiceArray.forEach((item:any) =>{
                if(item.refreshData && item.refreshData instanceof Function){
                    item.refreshData();
                }
            })
        }
    }

<#if ctrl.render?? && ctrl.render.code2??>
    ${ctrl.render.code2}
</#if>
