package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.r7rt_org.valuerule.anno.orgdept.*;
import com.ibiz.core.r7rt_org.domain.OrgDept;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[OrgDeptDTO]
 */
public class OrgDeptDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DEPTCODE]
     *
     */
    @OrgDeptDeptCodeDefault(info = "默认规则")
    private String deptCode;

    @JsonIgnore
    private boolean deptCodeDirtyFlag;

    /**
     * 属性 [ENABLE]
     *
     */
    @OrgDeptEnableDefault(info = "默认规则")
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;

    /**
     * 属性 [ORGDEPTNAME]
     *
     */
    @OrgDeptOrgDeptNameDefault(info = "默认规则")
    private String orgDeptName;

    @JsonIgnore
    private boolean orgDeptNameDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @OrgDeptCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @OrgDeptUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @OrgDeptCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @OrgDeptUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [ORGDEPTID]
     *
     */
    @OrgDeptOrgDeptIdDefault(info = "默认规则")
    private String orgDeptId;

    @JsonIgnore
    private boolean orgDeptIdDirtyFlag;

    /**
     * 属性 [LEVELCODE]
     *
     */
    @OrgDeptLevelCodeDefault(info = "默认规则")
    private String levelCode;

    @JsonIgnore
    private boolean levelCodeDirtyFlag;

    /**
     * 属性 [ORGNAME]
     *
     */
    @OrgDeptOrgNameDefault(info = "默认规则")
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;

    /**
     * 属性 [PORGDEPTNAME]
     *
     */
    @OrgDeptPOrgDeptNameDefault(info = "默认规则")
    private String pOrgDeptName;

    @JsonIgnore
    private boolean pOrgDeptNameDirtyFlag;

    /**
     * 属性 [ORGID]
     *
     */
    @OrgDeptOrgIdDefault(info = "默认规则")
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;

    /**
     * 属性 [PORGDEPTID]
     *
     */
    @OrgDeptPOrgDeptIdDefault(info = "默认规则")
    private String pOrgDeptId;

    @JsonIgnore
    private boolean pOrgDeptIdDirtyFlag;


    /**
     * 获取 [DEPTCODE]
     */
    @JsonProperty("deptcode")
    public String getDeptCode(){
        return deptCode ;
    }

    /**
     * 设置 [DEPTCODE]
     */
    @JsonProperty("deptcode")
    public void setDeptCode(String  deptCode){
        this.deptCode = deptCode ;
        this.deptCodeDirtyFlag = true ;
    }

    /**
     * 获取 [DEPTCODE]脏标记
     */
    @JsonIgnore
    public boolean getDeptCodeDirtyFlag(){
        return deptCodeDirtyFlag ;
    }

    /**
     * 获取 [ENABLE]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return enable ;
    }

    /**
     * 设置 [ENABLE]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [ENABLE]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return enableDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTNAME]
     */
    @JsonProperty("orgdeptname")
    public String getOrgDeptName(){
        return orgDeptName ;
    }

    /**
     * 设置 [ORGDEPTNAME]
     */
    @JsonProperty("orgdeptname")
    public void setOrgDeptName(String  orgDeptName){
        this.orgDeptName = orgDeptName ;
        this.orgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptNameDirtyFlag(){
        return orgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTID]
     */
    @JsonProperty("orgdeptid")
    public String getOrgDeptId(){
        return orgDeptId ;
    }

    /**
     * 设置 [ORGDEPTID]
     */
    @JsonProperty("orgdeptid")
    public void setOrgDeptId(String  orgDeptId){
        this.orgDeptId = orgDeptId ;
        this.orgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTID]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptIdDirtyFlag(){
        return orgDeptIdDirtyFlag ;
    }

    /**
     * 获取 [LEVELCODE]
     */
    @JsonProperty("levelcode")
    public String getLevelCode(){
        return levelCode ;
    }

    /**
     * 设置 [LEVELCODE]
     */
    @JsonProperty("levelcode")
    public void setLevelCode(String  levelCode){
        this.levelCode = levelCode ;
        this.levelCodeDirtyFlag = true ;
    }

    /**
     * 获取 [LEVELCODE]脏标记
     */
    @JsonIgnore
    public boolean getLevelCodeDirtyFlag(){
        return levelCodeDirtyFlag ;
    }

    /**
     * 获取 [ORGNAME]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return orgName ;
    }

    /**
     * 设置 [ORGNAME]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return orgNameDirtyFlag ;
    }

    /**
     * 获取 [PORGDEPTNAME]
     */
    @JsonProperty("porgdeptname")
    public String getPOrgDeptName(){
        return pOrgDeptName ;
    }

    /**
     * 设置 [PORGDEPTNAME]
     */
    @JsonProperty("porgdeptname")
    public void setPOrgDeptName(String  pOrgDeptName){
        this.pOrgDeptName = pOrgDeptName ;
        this.pOrgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [PORGDEPTNAME]脏标记
     */
    @JsonIgnore
    public boolean getPOrgDeptNameDirtyFlag(){
        return pOrgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [ORGID]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return orgId ;
    }

    /**
     * 设置 [ORGID]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGID]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return orgIdDirtyFlag ;
    }

    /**
     * 获取 [PORGDEPTID]
     */
    @JsonProperty("porgdeptid")
    public String getPOrgDeptId(){
        return pOrgDeptId ;
    }

    /**
     * 设置 [PORGDEPTID]
     */
    @JsonProperty("porgdeptid")
    public void setPOrgDeptId(String  pOrgDeptId){
        this.pOrgDeptId = pOrgDeptId ;
        this.pOrgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [PORGDEPTID]脏标记
     */
    @JsonIgnore
    public boolean getPOrgDeptIdDirtyFlag(){
        return pOrgDeptIdDirtyFlag ;
    }



    public OrgDept toDO() {
        OrgDept srfdomain = new OrgDept();
        if(getDeptCodeDirtyFlag())
            srfdomain.setDeptCode(deptCode);
        if(getEnableDirtyFlag())
            srfdomain.setEnable(enable);
        if(getOrgDeptNameDirtyFlag())
            srfdomain.setOrgDeptName(orgDeptName);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getOrgDeptIdDirtyFlag())
            srfdomain.setOrgDeptId(orgDeptId);
        if(getLevelCodeDirtyFlag())
            srfdomain.setLevelCode(levelCode);
        if(getOrgNameDirtyFlag())
            srfdomain.setOrgName(orgName);
        if(getPOrgDeptNameDirtyFlag())
            srfdomain.setPOrgDeptName(pOrgDeptName);
        if(getOrgIdDirtyFlag())
            srfdomain.setOrgId(orgId);
        if(getPOrgDeptIdDirtyFlag())
            srfdomain.setPOrgDeptId(pOrgDeptId);

        return srfdomain;
    }

    public void fromDO(OrgDept srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getDeptCodeDirtyFlag())
            this.setDeptCode(srfdomain.getDeptCode());
        if(srfdomain.getEnableDirtyFlag())
            this.setEnable(srfdomain.getEnable());
        if(srfdomain.getOrgDeptNameDirtyFlag())
            this.setOrgDeptName(srfdomain.getOrgDeptName());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getOrgDeptIdDirtyFlag())
            this.setOrgDeptId(srfdomain.getOrgDeptId());
        if(srfdomain.getLevelCodeDirtyFlag())
            this.setLevelCode(srfdomain.getLevelCode());
        if(srfdomain.getOrgNameDirtyFlag())
            this.setOrgName(srfdomain.getOrgName());
        if(srfdomain.getPOrgDeptNameDirtyFlag())
            this.setPOrgDeptName(srfdomain.getPOrgDeptName());
        if(srfdomain.getOrgIdDirtyFlag())
            this.setOrgId(srfdomain.getOrgId());
        if(srfdomain.getPOrgDeptIdDirtyFlag())
            this.setPOrgDeptId(srfdomain.getPOrgDeptId());

    }

    public List<OrgDeptDTO> fromDOPage(List<OrgDept> poPage)   {
        if(poPage == null)
            return null;
        List<OrgDeptDTO> dtos=new ArrayList<OrgDeptDTO>();
        for(OrgDept domain : poPage) {
            OrgDeptDTO dto = new OrgDeptDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

