package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.module2.valuerule.anno.healthcheck.*;
import com.ibiz.core.module2.domain.Healthcheck;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[HealthcheckDTO]
 */
public class HealthcheckDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [HEALTHCHECKID]
     *
     */
    @HealthcheckHealthcheckidDefault(info = "默认规则")
    private String healthcheckid;

    @JsonIgnore
    private boolean healthcheckidDirtyFlag;


    /**
     * 获取 [HEALTHCHECKID]
     */
    @JsonProperty("healthcheckid")
    public String getHealthcheckid(){
        return healthcheckid ;
    }

    /**
     * 设置 [HEALTHCHECKID]
     */
    @JsonProperty("healthcheckid")
    public void setHealthcheckid(String  healthcheckid){
        this.healthcheckid = healthcheckid ;
        this.healthcheckidDirtyFlag = true ;
    }

    /**
     * 获取 [HEALTHCHECKID]脏标记
     */
    @JsonIgnore
    public boolean getHealthcheckidDirtyFlag(){
        return healthcheckidDirtyFlag ;
    }



    public Healthcheck toDO() {
        Healthcheck srfdomain = new Healthcheck();
        if(getHealthcheckidDirtyFlag())
            srfdomain.setHealthcheckid(healthcheckid);

        return srfdomain;
    }

    public void fromDO(Healthcheck srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getHealthcheckidDirtyFlag())
            this.setHealthcheckid(srfdomain.getHealthcheckid());

    }

    public List<HealthcheckDTO> fromDOPage(List<Healthcheck> poPage)   {
        if(poPage == null)
            return null;
        List<HealthcheckDTO> dtos=new ArrayList<HealthcheckDTO>();
        for(Healthcheck domain : poPage) {
            HealthcheckDTO dto = new HealthcheckDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

