package com.ibiz.client.im.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.ibiz.core.client.model.IIM;
import com.ibiz.client.im.config.imClientProperties;
import com.ibiz.core.client.service.IIMClientService;
import com.ibiz.client.im.model.IMImpl;
import com.ibiz.client.im.feign.IMFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.util.log.IBIZLog;

/**
 * 实体[IM] 服务对象接口
 */
@Slf4j
@IBIZLog
@Service
public class IMClientServiceImpl implements IIMClientService {

    IMFeignClient iMFeignClient;

    @Autowired
    public IMClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,imClientProperties imClientProperties) {
        if (imClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.iMFeignClient = nameBuilder.target(IMFeignClient.class,"http://"+imClientProperties.getServiceId()+"/") ;
		}else if (imClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.iMFeignClient = nameBuilder.target(IMFeignClient.class,"http://"+imClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public IIM createModel() {
		return new IMImpl();
	}


    public Page<IIM> select(SearchContext context){
        return null ;
    }


    public void create(IIM im){
        IIM clientModel = iMFeignClient.create((IMImpl)im) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), im.getClass(), false);
        copier.copy(clientModel, im, null);
    }


    public void get(IIM im){
        IIM clientModel = iMFeignClient.get(im.getIMId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), im.getClass(), false);
        copier.copy(clientModel, im, null);
    }


    public void checkKey(IIM im){
        IIM clientModel = iMFeignClient.checkKey(im.getIMId(),(IMImpl)im) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), im.getClass(), false);
        copier.copy(clientModel, im, null);
    }


    public void save(IIM im){
        IIM clientModel = iMFeignClient.save(im.getIMId(),(IMImpl)im) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), im.getClass(), false);
        copier.copy(clientModel, im, null);
    }


    public void remove(IIM im){
        iMFeignClient.remove(im.getIMId()) ;
    }


    public void createAndStart(IIM im){
        IIM clientModel = iMFeignClient.createAndStart(im.getIMId(),(IMImpl)im) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), im.getClass(), false);
        copier.copy(clientModel, im, null);
    }


    public void getDraft(IIM im){
        IIM clientModel = iMFeignClient.getDraft(im.getIMId(),(IMImpl)im) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), im.getClass(), false);
        copier.copy(clientModel, im, null);
    }


    public void update(IIM im){
        IIM clientModel = iMFeignClient.update(im.getIMId(),(IMImpl)im) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), im.getClass(), false);
        copier.copy(clientModel, im, null);
    }


    public Page<IIM> fetchDefault(SearchContext context){
        Page<IMImpl> page = this.iMFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }



}

