package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.OrgDTO;
import com.ibiz.core.r7rt_org.domain.Org;
import com.ibiz.core.r7rt_org.service.IOrgService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.r7rt_org.filter.OrgSearchContext;

@Api(tags = {"Org" })
@RestController
@RequestMapping("")
public class OrgResource {

    @Autowired
    private IOrgService orgService;

    public IOrgService getOrgService() {
        return this.orgService;
    }

    @ApiOperation(value = "GetDraft", tags = {"Org" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}/getdraft")

    public ResponseEntity<OrgDTO> getDraft(@PathVariable("org_id") String org_id, @RequestBody OrgDTO orgdto) {
        Org org = orgdto.toDO();
    	org = orgService.getDraft(org) ;
    	orgdto.fromDO(org);
        return ResponseEntity.status(HttpStatus.OK).body(orgdto);
    }

    @ApiOperation(value = "getorgprent", tags = {"Org" },  notes = "getorgprent")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}/getorgprent")

    public ResponseEntity<OrgDTO> getOrgPrent(@PathVariable("org_id") String org_id, @RequestBody OrgDTO orgdto) {
        Org org = orgdto.toDO();
    	org = orgService.getOrgPrent(org) ;
    	orgdto.fromDO(org);
        return ResponseEntity.status(HttpStatus.OK).body(orgdto);
    }

    @ApiOperation(value = "Remove", tags = {"Org" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgs/{org_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("org_id") String org_id) {
        OrgDTO orgdto = new OrgDTO();
		Org domain = new Org();
		orgdto.setOrgId(org_id);
		domain.setOrgId(org_id);
        Boolean rst = orgService.remove(domain.getOrgId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Update", tags = {"Org" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgs/{org_id}")

    public ResponseEntity<OrgDTO> update(@PathVariable("org_id") String org_id, @RequestBody OrgDTO orgdto) {
		Org domain = orgdto.toDO();
        domain.setOrgId(org_id);
		orgService.update(domain);
		OrgDTO dto = new OrgDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"Org" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}")
    public ResponseEntity<OrgDTO> get(@PathVariable("org_id") String org_id) {
        OrgDTO dto = new OrgDTO();
        Org domain = orgService.get(org_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Create", tags = {"Org" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs")

    public ResponseEntity<OrgDTO> create(@RequestBody OrgDTO orgdto) {
        OrgDTO dto = new OrgDTO();
        Org domain = orgdto.toDO();
		orgService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"Org" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/{org_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody OrgDTO orgdto) {
        Org org = orgdto.toDO();
    	Boolean b = orgService.save(org) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "同步到用户组", tags = {"Org" },  notes = "同步到用户组")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/{org_id}/synctousergroup")

    public ResponseEntity<OrgDTO> syncToUserGroup(@PathVariable("org_id") String org_id, @RequestBody OrgDTO orgdto) {
        Org org = orgdto.toDO();
    	org = orgService.syncToUserGroup(org) ;
    	orgdto.fromDO(org);
        return ResponseEntity.status(HttpStatus.OK).body(orgdto);
    }

    @ApiOperation(value = "CheckKey", tags = {"Org" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody OrgDTO orgdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "getorgchild", tags = {"Org" },  notes = "getorgchild")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}/getorgchild")

    public ResponseEntity<OrgDTO> getOrgChild(@PathVariable("org_id") String org_id, @RequestBody OrgDTO orgdto) {
        Org org = orgdto.toDO();
    	org = orgService.getOrgChild(org) ;
    	orgdto.fromDO(org);
        return ResponseEntity.status(HttpStatus.OK).body(orgdto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"Org" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgs/fetchdefault")
	public ResponseEntity<Page<OrgDTO>> fetchDefault(OrgSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<OrgDTO> list = new ArrayList<OrgDTO>();
        
        Page<Org> domains = orgService.searchDefault(context) ;
        for(Org org : domains.getContent()){
            OrgDTO dto = new OrgDTO();
            dto.fromDO(org);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
