package com.ibiz.web.r7rt_org.controller;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import io.seata.spring.annotation.GlobalTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.web.r7rt_org.service.OrgDeptService;
import com.ibiz.web.r7rt_org.domain.OrgDept;
import com.ibiz.web.r7rt_org.filter.*;
import com.ibiz.util.log.IBIZLog;


@Slf4j
@IBIZLog
@RestController
@RequestMapping(value = "")
public class OrgDeptController {
	@Autowired
    OrgDeptService orgdeptservice;


    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgdepts/{orgdept_id}/save")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'')")
    public ResponseEntity<OrgDept> save(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) {
        OrgDept orgdept2 = orgdeptservice.save(orgdept_id, orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgdepts/{orgdept_id}/synctousergroup")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'')")
    public ResponseEntity<OrgDept> syncToUserGroup(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) {
        OrgDept orgdept2 = orgdeptservice.syncToUserGroup(orgdept_id, orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgdepts/{orgdept_id}/getorgdeptchild")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'READ')")
    public ResponseEntity<OrgDept> getOrgDeptChild(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) {
        OrgDept orgdept2 = orgdeptservice.getOrgDeptChild(orgdept_id, orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.DELETE, value = "/orgdepts/{orgdept_id}")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("orgdept_id") String orgdept_id) {
        boolean b = orgdeptservice.remove( orgdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgdepts/{orgdept_id}")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'READ')")
    public ResponseEntity<OrgDept> get(@PathVariable("orgdept_id") String orgdept_id) {
        OrgDept orgdept = orgdeptservice.get( orgdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.PUT, value = "/orgdepts/{orgdept_id}")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'UPDATE')")
    public ResponseEntity<OrgDept> update(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) {
        OrgDept orgdept2 = orgdeptservice.update(orgdept_id, orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/orgdepts/{orgdept_id}")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'UPDATE')")
    public ResponseEntity<OrgDept> api_update(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) {
        OrgDept orgdept2 = orgdeptservice.update(orgdept_id, orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgdepts/getdraft")
    @PreAuthorize("@orgdept_pms.check('CREATE')")
    public ResponseEntity<OrgDept> getDraft() {
        //OrgDept orgdept = orgdeptservice.getDraft( orgdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(new OrgDept());
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgdepts")
    @PreAuthorize("@orgdept_pms.check('CREATE')")
    public ResponseEntity<OrgDept> create(@RequestBody OrgDept orgdept) {
        OrgDept orgdept2 = orgdeptservice.create(orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgdepts/checkkey")
    @PreAuthorize("@orgdept_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody OrgDept orgdept) {
        boolean b = orgdeptservice.checkKey(orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgdepts/{orgdept_id}/getorgdeptprent")
    @PreAuthorize("@orgdept_pms.check(#orgdept_id,'READ')")
    public ResponseEntity<OrgDept> getOrgDeptPrent(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) {
        OrgDept orgdept2 = orgdeptservice.getOrgDeptPrent(orgdept_id, orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdept2);
    }

    //@GlobalTransactional
    @RequestMapping(method= RequestMethod.GET , value="/orgdepts/fetchdefault")
    @PreAuthorize("@orgdept_pms.check('READ')")
	public ResponseEntity<List<OrgDept>> fetchDefault(OrgDeptSearchContext searchContext,Pageable pageable) {
        
        Page<OrgDept> page = orgdeptservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    //@GlobalTransactional
    @RequestMapping(method= RequestMethod.GET , value="/orgdepts/fetchcur_org")
    @PreAuthorize("@orgdept_pms.check('READ')")
	public ResponseEntity<List<OrgDept>> fetchCUR_ORG(OrgDeptSearchContext searchContext,Pageable pageable) {
        
        Page<OrgDept> page = orgdeptservice.fetchCUR_ORG(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional

}
