package com.ibiz.web.r7rt_org.service;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.web.r7rt_org.domain.Org;
import com.ibiz.web.r7rt_org.filter.*;
import com.ibiz.web.r7rt_org.feign.OrgFeignClient;
import com.ibiz.web.WebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.log.IBIZLog;

@Slf4j
@IBIZLog
@Service
public class OrgService {

    OrgFeignClient client;

    @Autowired
    public OrgService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public Org getDraft(String org_id, Org org) {
        return client.getDraft(org_id, org);
    }

    public Org getOrgPrent(String org_id, Org org) {
        return client.getOrgPrent(org_id, org);
    }

    public boolean remove( String org_id) {
        return client.remove( org_id);
    }

    public Org update(String org_id, Org org) {
        return client.update(org_id, org);
    }

    public Org get( String org_id) {
        return client.get( org_id);
    }

	public Org create(Org org) {
        return client.create(org);
    }

    public Org save(String org_id, Org org) {
        return client.save(org_id, org);
    }

    public Org syncToUserGroup(String org_id, Org org) {
        return client.syncToUserGroup(org_id, org);
    }

    public boolean checkKey(Org org) {
        return client.checkKey(org);
    }

    public Org getOrgChild(String org_id, Org org) {
        return client.getOrgChild(org_id, org);
    }

	public Page<Org> fetchDefault(OrgSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
