package com.ibiz.client.htsc.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.ibiz.core.client.model.Ihealthcheck;
import com.ibiz.client.htsc.config.htscClientProperties;
import com.ibiz.core.client.service.IhealthcheckClientService;
import com.ibiz.client.htsc.model.healthcheckImpl;
import com.ibiz.client.htsc.feign.healthcheckFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[healthcheck] 服务对象接口
 */
@Service
public class healthcheckClientServiceImpl implements IhealthcheckClientService {

    healthcheckFeignClient healthcheckFeignClient;

    @Autowired
    public healthcheckClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,htscClientProperties htscClientProperties) {
        if (htscClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.healthcheckFeignClient = nameBuilder.target(healthcheckFeignClient.class,"http://"+htscClientProperties.getServiceId()+"/") ;
		}else if (htscClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.healthcheckFeignClient = nameBuilder.target(healthcheckFeignClient.class,"http://"+htscClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public Ihealthcheck createModel() {
		return new healthcheckImpl();
	}


    public Page<Ihealthcheck> select(SearchContext context){
        return null ;
    }


    public void getDraft(Ihealthcheck healthcheck){
        Ihealthcheck clientModel = healthcheckFeignClient.getDraft(healthcheck.getHEALTHCHECKID(),(healthcheckImpl)healthcheck) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), healthcheck.getClass(), false);
        copier.copy(clientModel, healthcheck, null);
    }


    public void remove(Ihealthcheck healthcheck){
        healthcheckFeignClient.remove(healthcheck.getHEALTHCHECKID()) ;
    }


    public void checkKey(Ihealthcheck healthcheck){
        Ihealthcheck clientModel = healthcheckFeignClient.checkKey(healthcheck.getHEALTHCHECKID(),(healthcheckImpl)healthcheck) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), healthcheck.getClass(), false);
        copier.copy(clientModel, healthcheck, null);
    }


    public void update(Ihealthcheck healthcheck){
        Ihealthcheck clientModel = healthcheckFeignClient.update(healthcheck.getHEALTHCHECKID(),(healthcheckImpl)healthcheck) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), healthcheck.getClass(), false);
        copier.copy(clientModel, healthcheck, null);
    }


    public void create(Ihealthcheck healthcheck){
        Ihealthcheck clientModel = healthcheckFeignClient.create((healthcheckImpl)healthcheck) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), healthcheck.getClass(), false);
        copier.copy(clientModel, healthcheck, null);
    }


    public void test(Ihealthcheck healthcheck){
        Ihealthcheck clientModel = healthcheckFeignClient.test(healthcheck.getHEALTHCHECKID(),(healthcheckImpl)healthcheck) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), healthcheck.getClass(), false);
        copier.copy(clientModel, healthcheck, null);
    }


    public void get(Ihealthcheck healthcheck){
        Ihealthcheck clientModel = healthcheckFeignClient.get(healthcheck.getHEALTHCHECKID()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), healthcheck.getClass(), false);
        copier.copy(clientModel, healthcheck, null);
    }


    public void save(Ihealthcheck healthcheck){
        Ihealthcheck clientModel = healthcheckFeignClient.save(healthcheck.getHEALTHCHECKID(),(healthcheckImpl)healthcheck) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), healthcheck.getClass(), false);
        copier.copy(clientModel, healthcheck, null);
    }


    public Page<Ihealthcheck> fetchDefault(SearchContext context){
        Page<healthcheckImpl> page = this.healthcheckFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }



}

