package com.ibiz.mybatis.module.po;

import com.ibiz.core.repository.po.PS;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.ibiz.util.annotation.PreField;
import com.ibiz.util.enums.FillMode;
import com.ibiz.util.enums.PredefinedType;

/**
 * 关系型数据实体表[PS] 对象
 */
@TableName(value = "T_PS",resultMap = "T_PSResultMap")
public class T_PSImpl implements PS,Serializable {

    /**
     * [更新时间]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEDATE)
    private Timestamp updateDate;
    /**
     * [更新时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateDateDirtyFlag;

    /**
     * [更新人]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMAN)
    private String updateMan;
    /**
     * [更新人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateManDirtyFlag;

    /**
     * [备注]
     */
    private String bz;
    /**
     * [备注]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bzDirtyFlag;

    /**
     * [建立时间]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEDATE)
    private Timestamp createDate;
    /**
     * [建立时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createDateDirtyFlag;

    /**
     * [采购单名称]
     */
    private String pSName;
    /**
     * [采购单名称]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean pSNameDirtyFlag;

    /**
     * [建立人]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMAN)
    private String createMan;
    /**
     * [建立人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createManDirtyFlag;

    /**
     * [采购单标识]
     */
    @TableId(value= "psid",type=IdType.UUID)
    private String pSId;
    /**
     * [采购单标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean pSIdDirtyFlag;

    /**
     * [NGRID]
     */
    private String ngrid;
    /**
     * [NGRID]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngridDirtyFlag;

    /**
     * [重要事项状态]
     */
    private String imstate;
    /**
     * [重要事项状态]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean imstateDirtyFlag;

    /**
     * 获取 [更新时间]
     */
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }
    /**
     * 获取 [更新人]
     */
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }
    /**
     * 获取 [备注]
     */
    public String getBz(){
        return this.bz ;
    }

    /**
     * 设置 [备注]
     */
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [备注]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return this.bzDirtyFlag ;
    }
    /**
     * 获取 [建立时间]
     */
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }
    /**
     * 获取 [采购单名称]
     */
    public String getPSName(){
        return this.pSName ;
    }

    /**
     * 设置 [采购单名称]
     */
    public void setPSName(String  pSName){
        this.pSName = pSName ;
        this.pSNameDirtyFlag = true ;
    }

    /**
     * 获取 [采购单名称]脏标记
     */
    @JsonIgnore
    public boolean getPSNameDirtyFlag(){
        return this.pSNameDirtyFlag ;
    }
    /**
     * 获取 [建立人]
     */
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }
    /**
     * 获取 [采购单标识]
     */
    public String getPSId(){
        return this.pSId ;
    }

    /**
     * 设置 [采购单标识]
     */
    public void setPSId(String  pSId){
        this.pSId = pSId ;
        this.pSIdDirtyFlag = true ;
    }

    /**
     * 获取 [采购单标识]脏标记
     */
    @JsonIgnore
    public boolean getPSIdDirtyFlag(){
        return this.pSIdDirtyFlag ;
    }
    /**
     * 获取 [NGRID]
     */
    public String getNgrid(){
        return this.ngrid ;
    }

    /**
     * 设置 [NGRID]
     */
    public void setNgrid(String  ngrid){
        this.ngrid = ngrid ;
        this.ngridDirtyFlag = true ;
    }

    /**
     * 获取 [NGRID]脏标记
     */
    @JsonIgnore
    public boolean getNgridDirtyFlag(){
        return this.ngridDirtyFlag ;
    }
    /**
     * 获取 [重要事项状态]
     */
    public String getImstate(){
        return this.imstate ;
    }

    /**
     * 设置 [重要事项状态]
     */
    public void setImstate(String  imstate){
        this.imstate = imstate ;
        this.imstateDirtyFlag = true ;
    }

    /**
     * 获取 [重要事项状态]脏标记
     */
    @JsonIgnore
    public boolean getImstateDirtyFlag(){
        return this.imstateDirtyFlag ;
    }
}