package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.r7rt_org.valuerule.anno.org.*;
import com.ibiz.core.r7rt_org.domain.Org;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[OrgDTO]
 */
public class OrgDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ENABLE]
     *
     */
    @OrgEnableDefault(info = "默认规则")
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @OrgUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [ORGNAME]
     *
     */
    @OrgOrgNameDefault(info = "默认规则")
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @OrgCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [ORGCODE]
     *
     */
    @OrgOrgCodeDefault(info = "默认规则")
    private String orgCode;

    @JsonIgnore
    private boolean orgCodeDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @OrgUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [LEVELCODE]
     *
     */
    @OrgLevelCodeDefault(info = "默认规则")
    private String levelCode;

    @JsonIgnore
    private boolean levelCodeDirtyFlag;

    /**
     * 属性 [ORGID]
     *
     */
    @OrgOrgIdDefault(info = "默认规则")
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @OrgCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [PORGNAME]
     *
     */
    @OrgPOrgNameDefault(info = "默认规则")
    private String pOrgName;

    @JsonIgnore
    private boolean pOrgNameDirtyFlag;

    /**
     * 属性 [PORGID]
     *
     */
    @OrgPOrgIdDefault(info = "默认规则")
    private String pOrgId;

    @JsonIgnore
    private boolean pOrgIdDirtyFlag;


    /**
     * 获取 [ENABLE]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return enable ;
    }

    /**
     * 设置 [ENABLE]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [ENABLE]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return enableDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [ORGNAME]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return orgName ;
    }

    /**
     * 设置 [ORGNAME]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return orgNameDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [ORGCODE]
     */
    @JsonProperty("orgcode")
    public String getOrgCode(){
        return orgCode ;
    }

    /**
     * 设置 [ORGCODE]
     */
    @JsonProperty("orgcode")
    public void setOrgCode(String  orgCode){
        this.orgCode = orgCode ;
        this.orgCodeDirtyFlag = true ;
    }

    /**
     * 获取 [ORGCODE]脏标记
     */
    @JsonIgnore
    public boolean getOrgCodeDirtyFlag(){
        return orgCodeDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [LEVELCODE]
     */
    @JsonProperty("levelcode")
    public String getLevelCode(){
        return levelCode ;
    }

    /**
     * 设置 [LEVELCODE]
     */
    @JsonProperty("levelcode")
    public void setLevelCode(String  levelCode){
        this.levelCode = levelCode ;
        this.levelCodeDirtyFlag = true ;
    }

    /**
     * 获取 [LEVELCODE]脏标记
     */
    @JsonIgnore
    public boolean getLevelCodeDirtyFlag(){
        return levelCodeDirtyFlag ;
    }

    /**
     * 获取 [ORGID]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return orgId ;
    }

    /**
     * 设置 [ORGID]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGID]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return orgIdDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [PORGNAME]
     */
    @JsonProperty("porgname")
    public String getPOrgName(){
        return pOrgName ;
    }

    /**
     * 设置 [PORGNAME]
     */
    @JsonProperty("porgname")
    public void setPOrgName(String  pOrgName){
        this.pOrgName = pOrgName ;
        this.pOrgNameDirtyFlag = true ;
    }

    /**
     * 获取 [PORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getPOrgNameDirtyFlag(){
        return pOrgNameDirtyFlag ;
    }

    /**
     * 获取 [PORGID]
     */
    @JsonProperty("porgid")
    public String getPOrgId(){
        return pOrgId ;
    }

    /**
     * 设置 [PORGID]
     */
    @JsonProperty("porgid")
    public void setPOrgId(String  pOrgId){
        this.pOrgId = pOrgId ;
        this.pOrgIdDirtyFlag = true ;
    }

    /**
     * 获取 [PORGID]脏标记
     */
    @JsonIgnore
    public boolean getPOrgIdDirtyFlag(){
        return pOrgIdDirtyFlag ;
    }



    public Org toDO() {
        Org srfdomain = new Org();
        if(getEnableDirtyFlag())
            srfdomain.setEnable(enable);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getOrgNameDirtyFlag())
            srfdomain.setOrgName(orgName);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getOrgCodeDirtyFlag())
            srfdomain.setOrgCode(orgCode);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getLevelCodeDirtyFlag())
            srfdomain.setLevelCode(levelCode);
        if(getOrgIdDirtyFlag())
            srfdomain.setOrgId(orgId);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getPOrgNameDirtyFlag())
            srfdomain.setPOrgName(pOrgName);
        if(getPOrgIdDirtyFlag())
            srfdomain.setPOrgId(pOrgId);

        return srfdomain;
    }

    public void fromDO(Org srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getEnableDirtyFlag())
            this.setEnable(srfdomain.getEnable());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getOrgNameDirtyFlag())
            this.setOrgName(srfdomain.getOrgName());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getOrgCodeDirtyFlag())
            this.setOrgCode(srfdomain.getOrgCode());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getLevelCodeDirtyFlag())
            this.setLevelCode(srfdomain.getLevelCode());
        if(srfdomain.getOrgIdDirtyFlag())
            this.setOrgId(srfdomain.getOrgId());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getPOrgNameDirtyFlag())
            this.setPOrgName(srfdomain.getPOrgName());
        if(srfdomain.getPOrgIdDirtyFlag())
            this.setPOrgId(srfdomain.getPOrgId());

    }

    public List<OrgDTO> fromDOPage(List<Org> poPage)   {
        if(poPage == null)
            return null;
        List<OrgDTO> dtos=new ArrayList<OrgDTO>();
        for(Org domain : poPage) {
            OrgDTO dto = new OrgDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

