package com.ibiz.client.htsc.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.ibiz.core.client.model.Ihealthcheck;
import com.ibiz.client.htsc.model.healthcheckImpl;
import com.ibiz.util.SearchContext;
/**
 * 实体[healthcheck] 服务对象接口
 */
public interface healthcheckFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/htsc-pos-nms/api/healthchecks/select")
    public Page<healthcheckImpl> select();


    @RequestMapping(method = RequestMethod.GET, value = "/htsc-pos-nms/api/healthchecks/{healthcheckid}/getdraft")
    public healthcheckImpl getDraft(@PathVariable("healthcheckid") String healthcheckid,@RequestBody healthcheckImpl healthcheck);


    @RequestMapping(method = RequestMethod.DELETE, value = "/htsc-pos-nms/api/healthchecks/{healthcheckid}")
    public Boolean remove(@PathVariable("healthcheckid") String healthcheckid);


    @RequestMapping(method = RequestMethod.POST, value = "/htsc-pos-nms/api/healthchecks/{healthcheckid}/checkkey")
    public healthcheckImpl checkKey(@PathVariable("healthcheckid") String healthcheckid,@RequestBody healthcheckImpl healthcheck);


    @RequestMapping(method = RequestMethod.PUT, value = "/htsc-pos-nms/api/healthchecks/{healthcheckid}")
    public healthcheckImpl update(@PathVariable("healthcheckid") String healthcheckid,@RequestBody healthcheckImpl healthcheck);


    @RequestMapping(method = RequestMethod.POST, value = "/htsc-pos-nms/api/healthchecks")
    public healthcheckImpl create(@RequestBody healthcheckImpl healthcheck);


    @RequestMapping(method = RequestMethod.POST, value = "/htsc-pos-nms/api/healthchecks/{healthcheckid}/test")
    public healthcheckImpl test(@PathVariable("healthcheckid") String healthcheckid,@RequestBody healthcheckImpl healthcheck);


    @RequestMapping(method = RequestMethod.GET, value = "/htsc-pos-nms/api/healthchecks/{healthcheckid}")
    public healthcheckImpl get(@PathVariable("healthcheckid") String healthcheckid);


    @RequestMapping(method = RequestMethod.POST, value = "/htsc-pos-nms/api/healthchecks/{healthcheckid}/save")
    public healthcheckImpl save(@PathVariable("healthcheckid") String healthcheckid,@RequestBody healthcheckImpl healthcheck);


    @RequestMapping(method = RequestMethod.GET, value = "/htsc-pos-nms/api/healthchecks/fetchdefault")
    public Page<healthcheckImpl> fetchDefault(SearchContext context);



}
