package com.ibiz.client.im.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.ibiz.core.client.model.IIM;
import com.ibiz.client.im.model.IMImpl;
import com.ibiz.util.SearchContext;
/**
 * 实体[IM] 服务对象接口
 */
public interface IMFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/web/ims/select")
    public Page<IMImpl> select();


    @RequestMapping(method = RequestMethod.POST, value = "/web/ims")
    public IMImpl create(@RequestBody IMImpl im);


    @RequestMapping(method = RequestMethod.GET, value = "/web/ims/{imid}")
    public IMImpl get(@PathVariable("imid") String imid);


    @RequestMapping(method = RequestMethod.POST, value = "/web/ims/{imid}/checkkey")
    public IMImpl checkKey(@PathVariable("imid") String imid,@RequestBody IMImpl im);


    @RequestMapping(method = RequestMethod.POST, value = "/web/ims/{imid}/save")
    public IMImpl save(@PathVariable("imid") String imid,@RequestBody IMImpl im);


    @RequestMapping(method = RequestMethod.DELETE, value = "/web/ims/{imid}")
    public Boolean remove(@PathVariable("imid") String imid);


    @RequestMapping(method = RequestMethod.POST, value = "/web/ims/{imid}/createandstart")
    public IMImpl createAndStart(@PathVariable("imid") String imid,@RequestBody IMImpl im);


    @RequestMapping(method = RequestMethod.GET, value = "/web/ims/{imid}/getdraft")
    public IMImpl getDraft(@PathVariable("imid") String imid,@RequestBody IMImpl im);


    @RequestMapping(method = RequestMethod.PUT, value = "/web/ims/{imid}")
    public IMImpl update(@PathVariable("imid") String imid,@RequestBody IMImpl im);


    @RequestMapping(method = RequestMethod.GET, value = "/web/ims/fetchdefault")
    public Page<IMImpl> fetchDefault(SearchContext context);



}
