package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.r7rt_org.valuerule.anno.orgdeptuser.*;
import com.ibiz.core.r7rt_org.domain.OrgDeptUser;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[OrgDeptUserDTO]
 */
public class OrgDeptUserDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @OrgDeptUserUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [ORGDEPTUSERID]
     *
     */
    @OrgDeptUserOrgDeptUserIdDefault(info = "默认规则")
    private String orgDeptUserId;

    @JsonIgnore
    private boolean orgDeptUserIdDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @OrgDeptUserCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @OrgDeptUserCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [ENABLE]
     *
     */
    @OrgDeptUserEnableDefault(info = "默认规则")
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;

    /**
     * 属性 [ORGDEPTUSERNAME]
     *
     */
    @OrgDeptUserOrgDeptUserNameDefault(info = "默认规则")
    private String orgDeptUserName;

    @JsonIgnore
    private boolean orgDeptUserNameDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @OrgDeptUserUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [ORGNAME]
     *
     */
    @OrgDeptUserOrgNameDefault(info = "默认规则")
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;

    /**
     * 属性 [ORGDEPTNAME]
     *
     */
    @OrgDeptUserOrgDeptNameDefault(info = "默认规则")
    private String orgDeptName;

    @JsonIgnore
    private boolean orgDeptNameDirtyFlag;

    /**
     * 属性 [ORGUSERNAME]
     *
     */
    @OrgDeptUserOrgUserNameDefault(info = "默认规则")
    private String orgUserName;

    @JsonIgnore
    private boolean orgUserNameDirtyFlag;

    /**
     * 属性 [ORGUSERID]
     *
     */
    @OrgDeptUserOrgUserIdDefault(info = "默认规则")
    private String orgUserId;

    @JsonIgnore
    private boolean orgUserIdDirtyFlag;

    /**
     * 属性 [ORGID]
     *
     */
    @OrgDeptUserOrgIdDefault(info = "默认规则")
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;

    /**
     * 属性 [ORGDEPTID]
     *
     */
    @OrgDeptUserOrgDeptIdDefault(info = "默认规则")
    private String orgDeptId;

    @JsonIgnore
    private boolean orgDeptIdDirtyFlag;


    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTUSERID]
     */
    @JsonProperty("orgdeptuserid")
    public String getOrgDeptUserId(){
        return orgDeptUserId ;
    }

    /**
     * 设置 [ORGDEPTUSERID]
     */
    @JsonProperty("orgdeptuserid")
    public void setOrgDeptUserId(String  orgDeptUserId){
        this.orgDeptUserId = orgDeptUserId ;
        this.orgDeptUserIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTUSERID]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptUserIdDirtyFlag(){
        return orgDeptUserIdDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [ENABLE]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return enable ;
    }

    /**
     * 设置 [ENABLE]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [ENABLE]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return enableDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTUSERNAME]
     */
    @JsonProperty("orgdeptusername")
    public String getOrgDeptUserName(){
        return orgDeptUserName ;
    }

    /**
     * 设置 [ORGDEPTUSERNAME]
     */
    @JsonProperty("orgdeptusername")
    public void setOrgDeptUserName(String  orgDeptUserName){
        this.orgDeptUserName = orgDeptUserName ;
        this.orgDeptUserNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTUSERNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptUserNameDirtyFlag(){
        return orgDeptUserNameDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [ORGNAME]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return orgName ;
    }

    /**
     * 设置 [ORGNAME]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return orgNameDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTNAME]
     */
    @JsonProperty("orgdeptname")
    public String getOrgDeptName(){
        return orgDeptName ;
    }

    /**
     * 设置 [ORGDEPTNAME]
     */
    @JsonProperty("orgdeptname")
    public void setOrgDeptName(String  orgDeptName){
        this.orgDeptName = orgDeptName ;
        this.orgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptNameDirtyFlag(){
        return orgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public String getOrgUserName(){
        return orgUserName ;
    }

    /**
     * 设置 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public void setOrgUserName(String  orgUserName){
        this.orgUserName = orgUserName ;
        this.orgUserNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserNameDirtyFlag(){
        return orgUserNameDirtyFlag ;
    }

    /**
     * 获取 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public String getOrgUserId(){
        return orgUserId ;
    }

    /**
     * 设置 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public void setOrgUserId(String  orgUserId){
        this.orgUserId = orgUserId ;
        this.orgUserIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERID]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserIdDirtyFlag(){
        return orgUserIdDirtyFlag ;
    }

    /**
     * 获取 [ORGID]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return orgId ;
    }

    /**
     * 设置 [ORGID]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGID]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return orgIdDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTID]
     */
    @JsonProperty("orgdeptid")
    public String getOrgDeptId(){
        return orgDeptId ;
    }

    /**
     * 设置 [ORGDEPTID]
     */
    @JsonProperty("orgdeptid")
    public void setOrgDeptId(String  orgDeptId){
        this.orgDeptId = orgDeptId ;
        this.orgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTID]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptIdDirtyFlag(){
        return orgDeptIdDirtyFlag ;
    }



    public OrgDeptUser toDO() {
        OrgDeptUser srfdomain = new OrgDeptUser();
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getOrgDeptUserIdDirtyFlag())
            srfdomain.setOrgDeptUserId(orgDeptUserId);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getEnableDirtyFlag())
            srfdomain.setEnable(enable);
        if(getOrgDeptUserNameDirtyFlag())
            srfdomain.setOrgDeptUserName(orgDeptUserName);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getOrgNameDirtyFlag())
            srfdomain.setOrgName(orgName);
        if(getOrgDeptNameDirtyFlag())
            srfdomain.setOrgDeptName(orgDeptName);
        if(getOrgUserNameDirtyFlag())
            srfdomain.setOrgUserName(orgUserName);
        if(getOrgUserIdDirtyFlag())
            srfdomain.setOrgUserId(orgUserId);
        if(getOrgIdDirtyFlag())
            srfdomain.setOrgId(orgId);
        if(getOrgDeptIdDirtyFlag())
            srfdomain.setOrgDeptId(orgDeptId);

        return srfdomain;
    }

    public void fromDO(OrgDeptUser srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getOrgDeptUserIdDirtyFlag())
            this.setOrgDeptUserId(srfdomain.getOrgDeptUserId());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getEnableDirtyFlag())
            this.setEnable(srfdomain.getEnable());
        if(srfdomain.getOrgDeptUserNameDirtyFlag())
            this.setOrgDeptUserName(srfdomain.getOrgDeptUserName());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getOrgNameDirtyFlag())
            this.setOrgName(srfdomain.getOrgName());
        if(srfdomain.getOrgDeptNameDirtyFlag())
            this.setOrgDeptName(srfdomain.getOrgDeptName());
        if(srfdomain.getOrgUserNameDirtyFlag())
            this.setOrgUserName(srfdomain.getOrgUserName());
        if(srfdomain.getOrgUserIdDirtyFlag())
            this.setOrgUserId(srfdomain.getOrgUserId());
        if(srfdomain.getOrgIdDirtyFlag())
            this.setOrgId(srfdomain.getOrgId());
        if(srfdomain.getOrgDeptIdDirtyFlag())
            this.setOrgDeptId(srfdomain.getOrgDeptId());

    }

    public List<OrgDeptUserDTO> fromDOPage(List<OrgDeptUser> poPage)   {
        if(poPage == null)
            return null;
        List<OrgDeptUserDTO> dtos=new ArrayList<OrgDeptUserDTO>();
        for(OrgDeptUser domain : poPage) {
            OrgDeptUserDTO dto = new OrgDeptUserDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

