package com.ibiz.web.module.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.web.module.service.PSService;
import com.ibiz.web.module.domain.PS;
import com.ibiz.web.module.filter.*;

@RestController
@RequestMapping(value = "")
public class PSController {
	@Autowired
    PSService psservice;


	@RequestMapping(method = RequestMethod.DELETE, value = "/ps/{ps_id}")
    @PreAuthorize("@ps_pms.check(#ps_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("ps_id") String ps_id) {
        boolean b = psservice.remove( ps_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ps")
    @PreAuthorize("@ps_pms.check('CREATE')")
    public ResponseEntity<PS> create(@RequestBody PS ps) {
        PS ps2 = psservice.create(ps);
        return ResponseEntity.status(HttpStatus.OK).body(ps2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/ps/{ps_id}")
    @PreAuthorize("@ps_pms.check(#ps_id,'READ')")
    public ResponseEntity<PS> get(@PathVariable("ps_id") String ps_id) {
        PS ps = psservice.get( ps_id);
        return ResponseEntity.status(HttpStatus.OK).body(ps);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ps/{ps_id}/xd")
    @PreAuthorize("@ps_pms.check(#ps_id,'')")
    public ResponseEntity<PS> xD(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) {
        PS ps2 = psservice.xD(ps_id, ps);
        return ResponseEntity.status(HttpStatus.OK).body(ps2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/ps/getdraft")
    @PreAuthorize("@ps_pms.check('CREATE')")
    public ResponseEntity<PS> getDraft() {
        //PS ps = psservice.getDraft( ps_id);
        return ResponseEntity.status(HttpStatus.OK).body(new PS());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ps/{ps_id}/save")
    @PreAuthorize("@ps_pms.check(#ps_id,'')")
    public ResponseEntity<PS> save(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) {
        PS ps2 = psservice.save(ps_id, ps);
        return ResponseEntity.status(HttpStatus.OK).body(ps2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/ps/{ps_id}")
    @PreAuthorize("@ps_pms.check(#ps_id,'UPDATE')")
    public ResponseEntity<PS> update(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) {
        PS ps2 = psservice.update(ps_id, ps);
        return ResponseEntity.status(HttpStatus.OK).body(ps2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/ps/{ps_id}")
    @PreAuthorize("@ps_pms.check(#ps_id,'UPDATE')")
    public ResponseEntity<PS> api_update(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) {
        PS ps2 = psservice.update(ps_id, ps);
        return ResponseEntity.status(HttpStatus.OK).body(ps2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ps/{ps_id}/createandstartim")
    @PreAuthorize("@ps_pms.check(#ps_id,'CREATE')")
    public ResponseEntity<PS> createAndStartIM(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) {
        PS ps2 = psservice.createAndStartIM(ps_id, ps);
        return ResponseEntity.status(HttpStatus.OK).body(ps2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ps/checkkey")
    @PreAuthorize("@ps_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody PS ps) {
        boolean b = psservice.checkKey(ps);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @RequestMapping(method= RequestMethod.GET , value="/ps/fetchdefault")
    @PreAuthorize("@ps_pms.check('READ')")
	public ResponseEntity<List<PS>> fetchDefault(PSSearchContext searchContext,Pageable pageable) {
        
        Page<PS> page = psservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


}
