package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.ibiz.service.web.dto.HealthcheckDTO;
import com.ibiz.core.module2.domain.Healthcheck;
import com.ibiz.core.module2.service.IHealthcheckService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.module2.filter.HealthcheckSearchContext;
import com.ibiz.util.log.IBIZLog;

@Slf4j
@IBIZLog
@Api(tags = {"Healthcheck" })
@RestController
@RequestMapping("")
public class HealthcheckResource {

    @Autowired
    private IHealthcheckService healthcheckService;

    public IHealthcheckService getHealthcheckService() {
        return this.healthcheckService;
    }

    @ApiOperation(value = "GetDraft", tags = {"Healthcheck" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/healthchecks/{healthcheck_id}/getdraft")

    public ResponseEntity<HealthcheckDTO> getDraft(@PathVariable("healthcheck_id") String healthcheck_id, @RequestBody HealthcheckDTO healthcheckdto) {
        Healthcheck healthcheck = healthcheckdto.toDO();
    	healthcheck = healthcheckService.getDraft(healthcheck) ;
    	healthcheckdto.fromDO(healthcheck);
        return ResponseEntity.status(HttpStatus.OK).body(healthcheckdto);
    }

    @ApiOperation(value = "Remove", tags = {"Healthcheck" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/healthchecks/{healthcheck_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("healthcheck_id") String healthcheck_id) {
        HealthcheckDTO healthcheckdto = new HealthcheckDTO();
		Healthcheck domain = new Healthcheck();
		healthcheckdto.setHealthcheckid(healthcheck_id);
		domain.setHealthcheckid(healthcheck_id);
        Boolean rst = healthcheckService.remove(domain.getHealthcheckid());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "CheckKey", tags = {"Healthcheck" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/healthchecks/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody HealthcheckDTO healthcheckdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Update", tags = {"Healthcheck" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/healthchecks/{healthcheck_id}")

    public ResponseEntity<HealthcheckDTO> update(@PathVariable("healthcheck_id") String healthcheck_id, @RequestBody HealthcheckDTO healthcheckdto) {
		Healthcheck domain = healthcheckdto.toDO();
        domain.setHealthcheckid(healthcheck_id);
		healthcheckService.update(domain);
		HealthcheckDTO dto = new HealthcheckDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Create", tags = {"Healthcheck" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/healthchecks")

    public ResponseEntity<HealthcheckDTO> create(@RequestBody HealthcheckDTO healthcheckdto) {
        HealthcheckDTO dto = new HealthcheckDTO();
        Healthcheck domain = healthcheckdto.toDO();
		healthcheckService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "test", tags = {"Healthcheck" },  notes = "test")
	@RequestMapping(method = RequestMethod.POST, value = "/web/healthchecks/{healthcheck_id}/test")

    public ResponseEntity<HealthcheckDTO> test(@PathVariable("healthcheck_id") String healthcheck_id, @RequestBody HealthcheckDTO healthcheckdto) {
        Healthcheck healthcheck = healthcheckdto.toDO();
    	healthcheck = healthcheckService.test(healthcheck) ;
    	healthcheckdto.fromDO(healthcheck);
        return ResponseEntity.status(HttpStatus.OK).body(healthcheckdto);
    }

    @ApiOperation(value = "Get", tags = {"Healthcheck" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/healthchecks/{healthcheck_id}")
    public ResponseEntity<HealthcheckDTO> get(@PathVariable("healthcheck_id") String healthcheck_id) {
        HealthcheckDTO dto = new HealthcheckDTO();
        Healthcheck domain = healthcheckService.get(healthcheck_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"Healthcheck" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/healthchecks/{healthcheck_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody HealthcheckDTO healthcheckdto) {
        Healthcheck healthcheck = healthcheckdto.toDO();
    	Boolean b = healthcheckService.save(healthcheck) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"Healthcheck" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/healthchecks/fetchdefault")
	public ResponseEntity<Page<HealthcheckDTO>> fetchDefault(HealthcheckSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<HealthcheckDTO> list = new ArrayList<HealthcheckDTO>();
        
        Page<Healthcheck> domains = healthcheckService.searchDefault(context) ;
        for(Healthcheck healthcheck : domains.getContent()){
            HealthcheckDTO dto = new HealthcheckDTO();
            dto.fromDO(healthcheck);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
