package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.ibiz.service.web.dto.OrgUserDTO;
import com.ibiz.core.r7rt_org.domain.OrgUser;
import com.ibiz.core.r7rt_org.service.IOrgUserService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.r7rt_org.filter.OrgUserSearchContext;
import com.ibiz.util.log.IBIZLog;

@Slf4j
@IBIZLog
@Api(tags = {"OrgUser" })
@RestController
@RequestMapping("")
public class OrgUserResource {

    @Autowired
    private IOrgUserService orguserService;

    public IOrgUserService getOrguserService() {
        return this.orguserService;
    }

    @ApiOperation(value = "Remove", tags = {"OrgUser" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgusers/{orguser_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("orguser_id") String orguser_id) {
        OrgUserDTO orguserdto = new OrgUserDTO();
		OrgUser domain = new OrgUser();
		orguserdto.setOrgUserId(orguser_id);
		domain.setOrgUserId(orguser_id);
        Boolean rst = orguserService.remove(domain.getOrgUserId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Save", tags = {"OrgUser" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/{orguser_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody OrgUserDTO orguserdto) {
        OrgUser orguser = orguserdto.toDO();
    	Boolean b = orguserService.save(orguser) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Update", tags = {"OrgUser" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgusers/{orguser_id}")

    public ResponseEntity<OrgUserDTO> update(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUserDTO orguserdto) {
		OrgUser domain = orguserdto.toDO();
        domain.setOrgUserId(orguser_id);
		orguserService.update(domain);
		OrgUserDTO dto = new OrgUserDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"OrgUser" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody OrgUserDTO orguserdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraft", tags = {"OrgUser" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/{orguser_id}/getdraft")

    public ResponseEntity<OrgUserDTO> getDraft(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUserDTO orguserdto) {
        OrgUser orguser = orguserdto.toDO();
    	orguser = orguserService.getDraft(orguser) ;
    	orguserdto.fromDO(orguser);
        return ResponseEntity.status(HttpStatus.OK).body(orguserdto);
    }

    @ApiOperation(value = "Create", tags = {"OrgUser" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers")

    public ResponseEntity<OrgUserDTO> create(@RequestBody OrgUserDTO orguserdto) {
        OrgUserDTO dto = new OrgUserDTO();
        OrgUser domain = orguserdto.toDO();
		orguserService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"OrgUser" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/{orguser_id}")
    public ResponseEntity<OrgUserDTO> get(@PathVariable("orguser_id") String orguser_id) {
        OrgUserDTO dto = new OrgUserDTO();
        OrgUser domain = orguserService.get(orguser_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"OrgUser" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgusers/fetchdefault")
	public ResponseEntity<Page<OrgUserDTO>> fetchDefault(OrgUserSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<OrgUserDTO> list = new ArrayList<OrgUserDTO>();
        
        Page<OrgUser> domains = orguserService.searchDefault(context) ;
        for(OrgUser orguser : domains.getContent()){
            OrgUserDTO dto = new OrgUserDTO();
            dto.fromDO(orguser);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
