package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.module.valuerule.anno.ps.*;
import com.ibiz.core.module.domain.PS;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[PSDTO]
 */
public class PSDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @PSUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @PSUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [BZ]
     *
     */
    @PSBzDefault(info = "默认规则")
    private String bz;

    @JsonIgnore
    private boolean bzDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @PSCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [PSNAME]
     *
     */
    @PSPSNameDefault(info = "默认规则")
    private String pSName;

    @JsonIgnore
    private boolean pSNameDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @PSCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [PSID]
     *
     */
    @PSPSIdDefault(info = "默认规则")
    private String pSId;

    @JsonIgnore
    private boolean pSIdDirtyFlag;


    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [BZ]
     */
    @JsonProperty("bz")
    public String getBz(){
        return bz ;
    }

    /**
     * 设置 [BZ]
     */
    @JsonProperty("bz")
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [BZ]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return bzDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [PSNAME]
     */
    @JsonProperty("psname")
    public String getPSName(){
        return pSName ;
    }

    /**
     * 设置 [PSNAME]
     */
    @JsonProperty("psname")
    public void setPSName(String  pSName){
        this.pSName = pSName ;
        this.pSNameDirtyFlag = true ;
    }

    /**
     * 获取 [PSNAME]脏标记
     */
    @JsonIgnore
    public boolean getPSNameDirtyFlag(){
        return pSNameDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [PSID]
     */
    @JsonProperty("psid")
    public String getPSId(){
        return pSId ;
    }

    /**
     * 设置 [PSID]
     */
    @JsonProperty("psid")
    public void setPSId(String  pSId){
        this.pSId = pSId ;
        this.pSIdDirtyFlag = true ;
    }

    /**
     * 获取 [PSID]脏标记
     */
    @JsonIgnore
    public boolean getPSIdDirtyFlag(){
        return pSIdDirtyFlag ;
    }



    public PS toDO() {
        PS srfdomain = new PS();
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getBzDirtyFlag())
            srfdomain.setBz(bz);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getPSNameDirtyFlag())
            srfdomain.setPSName(pSName);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getPSIdDirtyFlag())
            srfdomain.setPSId(pSId);

        return srfdomain;
    }

    public void fromDO(PS srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getBzDirtyFlag())
            this.setBz(srfdomain.getBz());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getPSNameDirtyFlag())
            this.setPSName(srfdomain.getPSName());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getPSIdDirtyFlag())
            this.setPSId(srfdomain.getPSId());

    }

    public List<PSDTO> fromDOPage(List<PS> poPage)   {
        if(poPage == null)
            return null;
        List<PSDTO> dtos=new ArrayList<PSDTO>();
        for(PS domain : poPage) {
            PSDTO dto = new PSDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

