package com.ibiz.web.module.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.web.module.domain.PS;
import com.ibiz.web.module.filter.*;


public interface PSFeignClient {



	@RequestMapping(method = RequestMethod.DELETE, value = "/web/ps/{ps_id}")
    public Boolean remove(@PathVariable("ps_id") String ps_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ps")
    public PS create(@RequestBody PS ps) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/ps/{ps_id}")
    public PS get(@PathVariable("ps_id") String ps_id) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/ps/{ps_id}/getdraft")
    public PS getDraft(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ps/{ps_id}/save")
    public PS save(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/ps/{ps_id}")
    public PS update(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ps/{ps_id}/createandstartim")
    public PS createAndStartIM(@PathVariable("ps_id") String ps_id, @RequestBody PS ps) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ps/checkkey")
    public Boolean checkKey(@RequestBody PS ps) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/ps/fetchdefault")
	public Page<PS> fetchDefault(PSSearchContext searchContext) ;
}
