
package com.ibiz.web.module.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.web.module.domain.PS;
import com.ibiz.web.module.filter.*;
import com.ibiz.web.module.feign.PSFeignClient;
import com.ibiz.web.WebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;

@Service
public class PSService {

    PSFeignClient client;

    @Autowired
    public PSService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(PSFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(PSFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public boolean remove( String ps_id) {
        return client.remove( ps_id);
    }

	public PS create(PS ps) {
        return client.create(ps);
    }

    public PS get( String ps_id) {
        return client.get( ps_id);
    }

    public PS getDraft(String ps_id, PS ps) {
        return client.getDraft(ps_id, ps);
    }

    public PS save(String ps_id, PS ps) {
        return client.save(ps_id, ps);
    }

    public PS update(String ps_id, PS ps) {
        return client.update(ps_id, ps);
    }

    public PS createAndStartIM(String ps_id, PS ps) {
        return client.createAndStartIM(ps_id, ps);
    }

    public boolean checkKey(PS ps) {
        return client.checkKey(ps);
    }

	public Page<PS> fetchDefault(PSSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
