package com.ibiz.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.PSRepository;
import com.ibiz.core.repository.po.PS;
import com.ibiz.core.module.filter.PSSearchContext;
import com.ibiz.mybatis.module.mapper.T_PSMapper;
import com.ibiz.mybatis.module.po.T_PSImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_PS]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "ps", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_PSRepositoryImpl extends ServiceImpl<T_PSMapper, T_PSImpl> implements PSRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_PS]持久层映射对象
     */
    @Autowired
	T_PSMapper t_PSMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public PS createPO(){
        return new T_PSImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public PS get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(PS po){
        boolean bOk = this.save((T_PSImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(PS po){
        boolean bOk = this.updateById((T_PSImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<PS> searchDefault(PSSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<PS> page_datas=t_PSMapper.searchDefault(page,context,qw);
        List<PS> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<PS>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.module.domain.PS convert2Domain( PS po ,com.ibiz.core.module.domain.PS domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.module.domain.PS();
        }
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getBzDirtyFlag())
        domain.setBz(po.getBz());
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getPSNameDirtyFlag())
        domain.setPSName(po.getPSName());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getPSIdDirtyFlag())
        domain.setPSId(po.getPSId());
        //if(po.getNgridDirtyFlag())
        domain.setNgrid(po.getNgrid());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public PS convert2PO(com.ibiz.core.module.domain.PS domain , PS po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getBzDirtyFlag())
            po.setBz(domain.getBz());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getPSNameDirtyFlag())
            po.setPSName(domain.getPSName());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getPSIdDirtyFlag())
            po.setPSId(domain.getPSId());
        if(domain.getNgridDirtyFlag())
            po.setNgrid(domain.getNgrid());

        return po ;
    }
}
