package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.OrgDeptUserDTO;
import com.ibiz.core.r7rt_org.domain.OrgDeptUser;
import com.ibiz.core.r7rt_org.service.IOrgDeptUserService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.r7rt_org.filter.OrgDeptUserSearchContext;

@Api(tags = {"OrgDeptUser" })
@RestController
@RequestMapping("")
public class OrgDeptUserResource {

    @Autowired
    private IOrgDeptUserService orgdeptuserService;

    public IOrgDeptUserService getOrgdeptuserService() {
        return this.orgdeptuserService;
    }

    @ApiOperation(value = "GetDraft", tags = {"OrgDeptUser" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdeptusers/{orgdeptuser_id}/getdraft")

    public ResponseEntity<OrgDeptUserDTO> getDraft(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUserDTO orgdeptuserdto) {
        OrgDeptUser orgdeptuser = orgdeptuserdto.toDO();
    	orgdeptuser = orgdeptuserService.getDraft(orgdeptuser) ;
    	orgdeptuserdto.fromDO(orgdeptuser);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptuserdto);
    }

    @ApiOperation(value = "Get", tags = {"OrgDeptUser" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdeptusers/{orgdeptuser_id}")
    public ResponseEntity<OrgDeptUserDTO> get(@PathVariable("orgdeptuser_id") String orgdeptuser_id) {
        OrgDeptUserDTO dto = new OrgDeptUserDTO();
        OrgDeptUser domain = orgdeptuserService.get(orgdeptuser_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"OrgDeptUser" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdeptusers/{orgdeptuser_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody OrgDeptUserDTO orgdeptuserdto) {
        OrgDeptUser orgdeptuser = orgdeptuserdto.toDO();
    	Boolean b = orgdeptuserService.save(orgdeptuser) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Create", tags = {"OrgDeptUser" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdeptusers")

    public ResponseEntity<OrgDeptUserDTO> create(@RequestBody OrgDeptUserDTO orgdeptuserdto) {
        OrgDeptUserDTO dto = new OrgDeptUserDTO();
        OrgDeptUser domain = orgdeptuserdto.toDO();
		orgdeptuserService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"OrgDeptUser" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgdeptusers/{orgdeptuser_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("orgdeptuser_id") String orgdeptuser_id) {
        OrgDeptUserDTO orgdeptuserdto = new OrgDeptUserDTO();
		OrgDeptUser domain = new OrgDeptUser();
		orgdeptuserdto.setOrgDeptUserId(orgdeptuser_id);
		domain.setOrgDeptUserId(orgdeptuser_id);
        Boolean rst = orgdeptuserService.remove(domain.getOrgDeptUserId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Update", tags = {"OrgDeptUser" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgdeptusers/{orgdeptuser_id}")

    public ResponseEntity<OrgDeptUserDTO> update(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUserDTO orgdeptuserdto) {
		OrgDeptUser domain = orgdeptuserdto.toDO();
        domain.setOrgDeptUserId(orgdeptuser_id);
		orgdeptuserService.update(domain);
		OrgDeptUserDTO dto = new OrgDeptUserDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"OrgDeptUser" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdeptusers/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody OrgDeptUserDTO orgdeptuserdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取getorgdeptuser", tags = {"OrgDeptUser" } ,notes = "获取getorgdeptuser")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgdeptusers/fetchgetorgdeptuser")
	public ResponseEntity<Page<OrgDeptUserDTO>> fetchGetorgdeptuser(OrgDeptUserSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<OrgDeptUserDTO> list = new ArrayList<OrgDeptUserDTO>();
        
        Page<OrgDeptUser> domains = orgdeptuserService.searchGetorgdeptuser(context) ;
        for(OrgDeptUser orgdeptuser : domains.getContent()){
            OrgDeptUserDTO dto = new OrgDeptUserDTO();
            dto.fromDO(orgdeptuser);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取DEFAULT", tags = {"OrgDeptUser" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgdeptusers/fetchdefault")
	public ResponseEntity<Page<OrgDeptUserDTO>> fetchDefault(OrgDeptUserSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<OrgDeptUserDTO> list = new ArrayList<OrgDeptUserDTO>();
        
        Page<OrgDeptUser> domains = orgdeptuserService.searchDefault(context) ;
        for(OrgDeptUser orgdeptuser : domains.getContent()){
            OrgDeptUserDTO dto = new OrgDeptUserDTO();
            dto.fromDO(orgdeptuser);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
