package com.ibiz.wfweb;

import java.util.List;

import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibiz.util.web.SearchContextHandlerMethodArgumentResolver;
import com.ibiz.util.serialize.DomainSerializerProvider;
import lombok.Data;

@SpringBootApplication(exclude = {
    
})
@Import({
    FeignClientsConfiguration.class
})
@ComponentScans({
        @ComponentScan(basePackages = {"com.ibiz.util", "com.ibiz.wfweb"})
})
@EnableDiscoveryClient
@Configuration
@EnableFeignClients
public class WFWebApplication extends WebMvcConfigurerAdapter{

    public static void main(String[] args) {
        SpringApplicationBuilder builder=new SpringApplicationBuilder(WFWebApplication.class);
        builder.run(args);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJacksonHttpMessageConverter(ObjectMapper objectMapper) {
    	objectMapper.setSerializerProvider(new DomainSerializerProvider()) ;
    	final MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(objectMapper);
        return converter;
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
        argumentResolvers.add(new SearchContextHandlerMethodArgumentResolver());
    }

}
