package com.ibiz.client.wf.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.ibiz.core.client.model.IWFIAAction;
import com.ibiz.client.wf.model.WFIAActionImpl;
import com.ibiz.util.SearchContext;
/**
 * 实体[WFIAAction] 服务对象接口
 */
public interface WFIAActionFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfiaactions/select")
    public Page<WFIAActionImpl> select();


    @RequestMapping(method = RequestMethod.DELETE, value = "/wfapi/wfiaactions/{wfiaactionid}")
    public Boolean remove(@PathVariable("wfiaactionid") String wfiaactionid);


    @RequestMapping(method = RequestMethod.PUT, value = "/wfapi/wfiaactions/{wfiaactionid}")
    public WFIAActionImpl update(@PathVariable("wfiaactionid") String wfiaactionid,@RequestBody WFIAActionImpl wfiaaction);


    @RequestMapping(method = RequestMethod.POST, value = "/wfapi/wfiaactions/{wfiaactionid}/save")
    public WFIAActionImpl save(@PathVariable("wfiaactionid") String wfiaactionid,@RequestBody WFIAActionImpl wfiaaction);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfiaactions/{wfiaactionid}")
    public WFIAActionImpl get(@PathVariable("wfiaactionid") String wfiaactionid);


    @RequestMapping(method = RequestMethod.POST, value = "/wfapi/wfiaactions/{wfiaactionid}/checkkey")
    public WFIAActionImpl checkKey(@PathVariable("wfiaactionid") String wfiaactionid,@RequestBody WFIAActionImpl wfiaaction);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfiaactions/{wfiaactionid}/getdraft")
    public WFIAActionImpl getDraft(@PathVariable("wfiaactionid") String wfiaactionid,@RequestBody WFIAActionImpl wfiaaction);


    @RequestMapping(method = RequestMethod.POST, value = "/wfapi/wfiaactions")
    public WFIAActionImpl create(@RequestBody WFIAActionImpl wfiaaction);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfiaactions/fetchdefault")
    public Page<WFIAActionImpl> fetchDefault(SearchContext context);



}
