package com.ibiz.client.wf.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.ibiz.core.client.model.IWFSTEPDATA;
import com.ibiz.client.wf.model.WFSTEPDATAImpl;
import com.ibiz.util.SearchContext;
/**
 * 实体[WFSTEPDATA] 服务对象接口
 */
public interface WFSTEPDATAFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfstepdata/select")
    public Page<WFSTEPDATAImpl> select();


    @RequestMapping(method = RequestMethod.POST, value = "/wfapi/wfstepdata/{wfstepdataid}/checkkey")
    public WFSTEPDATAImpl checkKey(@PathVariable("wfstepdataid") String wfstepdataid,@RequestBody WFSTEPDATAImpl wfstepdata);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfstepdata/{wfstepdataid}")
    public WFSTEPDATAImpl get(@PathVariable("wfstepdataid") String wfstepdataid);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfstepdata/{wfstepdataid}/getdraft")
    public WFSTEPDATAImpl getDraft(@PathVariable("wfstepdataid") String wfstepdataid,@RequestBody WFSTEPDATAImpl wfstepdata);


    @RequestMapping(method = RequestMethod.POST, value = "/wfapi/wfstepdata")
    public WFSTEPDATAImpl create(@RequestBody WFSTEPDATAImpl wfstepdata);


    @RequestMapping(method = RequestMethod.PUT, value = "/wfapi/wfstepdata/{wfstepdataid}")
    public WFSTEPDATAImpl update(@PathVariable("wfstepdataid") String wfstepdataid,@RequestBody WFSTEPDATAImpl wfstepdata);


    @RequestMapping(method = RequestMethod.POST, value = "/wfapi/wfstepdata/{wfstepdataid}/save")
    public WFSTEPDATAImpl save(@PathVariable("wfstepdataid") String wfstepdataid,@RequestBody WFSTEPDATAImpl wfstepdata);


    @RequestMapping(method = RequestMethod.DELETE, value = "/wfapi/wfstepdata/{wfstepdataid}")
    public Boolean remove(@PathVariable("wfstepdataid") String wfstepdataid);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfstepdata/fetchbybswfdata")
    public Page<WFSTEPDATAImpl> fetchByBswfdata(SearchContext context);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfstepdata/fetchbybsdata")
    public Page<WFSTEPDATAImpl> fetchByBsdata(SearchContext context);


    @RequestMapping(method = RequestMethod.GET, value = "/wfapi/wfstepdata/fetchdefault")
    public Page<WFSTEPDATAImpl> fetchDefault(SearchContext context);



}
