package com.ibiz.client.ps.model;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.client.model.IPS;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 接口实体[PS] 对象
 */
public class PSImpl implements IPS,Serializable{

    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    public Timestamp createDate;

    @JsonIgnore
    public boolean createDateDirtyFlag;
    
    /**
     * 采购单名称
     */
    public String pSName;

    @JsonIgnore
    public boolean pSNameDirtyFlag;
    
    /**
     * 建立人
     */
    public String createMan;

    @JsonIgnore
    public boolean createManDirtyFlag;
    
    /**
     * 采购单标识
     */
    public String pSId;

    @JsonIgnore
    public boolean pSIdDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    public Timestamp updateDate;

    @JsonIgnore
    public boolean updateDateDirtyFlag;
    
    /**
     * 更新人
     */
    public String updateMan;

    @JsonIgnore
    public boolean updateManDirtyFlag;
    
    /**
     * IMSTATE
     */
    public String imstate;

    @JsonIgnore
    public boolean imstateDirtyFlag;
    
    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

     /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }   

    /**
     * 获取 [采购单名称]
     */
    @JsonProperty("psname")
    public String getPSName(){
        return this.pSName ;
    }

    /**
     * 设置 [采购单名称]
     */
    @JsonProperty("psname")
    public void setPSName(String  pSName){
        this.pSName = pSName ;
        this.pSNameDirtyFlag = true ;
    }

     /**
     * 获取 [采购单名称]脏标记
     */
    @JsonIgnore
    public boolean getPSNameDirtyFlag(){
        return this.pSNameDirtyFlag ;
    }   

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

     /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }   

    /**
     * 获取 [采购单标识]
     */
    @JsonProperty("psid")
    public String getPSId(){
        return this.pSId ;
    }

    /**
     * 设置 [采购单标识]
     */
    @JsonProperty("psid")
    public void setPSId(String  pSId){
        this.pSId = pSId ;
        this.pSIdDirtyFlag = true ;
    }

     /**
     * 获取 [采购单标识]脏标记
     */
    @JsonIgnore
    public boolean getPSIdDirtyFlag(){
        return this.pSIdDirtyFlag ;
    }   

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

     /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }   

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

     /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }   

    /**
     * 获取 [IMSTATE]
     */
    @JsonProperty("imstate")
    public String getImstate(){
        return this.imstate ;
    }

    /**
     * 设置 [IMSTATE]
     */
    @JsonProperty("imstate")
    public void setImstate(String  imstate){
        this.imstate = imstate ;
        this.imstateDirtyFlag = true ;
    }

     /**
     * 获取 [IMSTATE]脏标记
     */
    @JsonIgnore
    public boolean getImstateDirtyFlag(){
        return this.imstateDirtyFlag ;
    }   

}
