package com.ibiz.wfweb2.r7rt_org.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[部门]
 */
public class OrgDept implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 部门编码
     */
    private String deptCode;

    @JsonIgnore
    private boolean deptCodeDirtyFlag;
    
    /**
     * 是否启用
     */
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;
    
    /**
     * 部门名称
     */
    private String orgDeptName;

    @JsonIgnore
    private boolean orgDeptNameDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 部门标识
     */
    private String orgDeptId;

    @JsonIgnore
    private boolean orgDeptIdDirtyFlag;
    
    /**
     * 级别编码
     */
    private String levelCode;

    @JsonIgnore
    private boolean levelCodeDirtyFlag;
    
    /**
     * 组织名称
     */
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;
    
    /**
     * 部门名称
     */
    private String pOrgDeptName;

    @JsonIgnore
    private boolean pOrgDeptNameDirtyFlag;
    
    /**
     * 组织标识
     */
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;
    
    /**
     * 部门标识
     */
    private String pOrgDeptId;

    @JsonIgnore
    private boolean pOrgDeptIdDirtyFlag;
    

    /**
     * 获取 [部门编码]
     */
    @JsonProperty("deptcode")
    public String getDeptCode(){
        return this.deptCode ;
    }

    /**
     * 设置 [部门编码]
     */
    @JsonProperty("deptcode")
    public void setDeptCode(String  deptCode){
        this.deptCode = deptCode ;
        this.deptCodeDirtyFlag = true ;
    }

    /**
     * 获取 [部门编码]脏标记
     */
    @JsonIgnore
    public boolean getDeptCodeDirtyFlag(){
        return this.deptCodeDirtyFlag ;
    }

    /**
     * 获取 [是否启用]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return this.enable ;
    }

    /**
     * 设置 [是否启用]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [是否启用]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return this.enableDirtyFlag ;
    }

    /**
     * 获取 [部门名称]
     */
    @JsonProperty("orgdeptname")
    public String getOrgDeptName(){
        return this.orgDeptName ;
    }

    /**
     * 设置 [部门名称]
     */
    @JsonProperty("orgdeptname")
    public void setOrgDeptName(String  orgDeptName){
        this.orgDeptName = orgDeptName ;
        this.orgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [部门名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptNameDirtyFlag(){
        return this.orgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [部门标识]
     */
    @JsonProperty("orgdeptid")
    public String getOrgDeptId(){
        return this.orgDeptId ;
    }

    /**
     * 设置 [部门标识]
     */
    @JsonProperty("orgdeptid")
    public void setOrgDeptId(String  orgDeptId){
        this.orgDeptId = orgDeptId ;
        this.orgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [部门标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptIdDirtyFlag(){
        return this.orgDeptIdDirtyFlag ;
    }

    /**
     * 获取 [级别编码]
     */
    @JsonProperty("levelcode")
    public String getLevelCode(){
        return this.levelCode ;
    }

    /**
     * 设置 [级别编码]
     */
    @JsonProperty("levelcode")
    public void setLevelCode(String  levelCode){
        this.levelCode = levelCode ;
        this.levelCodeDirtyFlag = true ;
    }

    /**
     * 获取 [级别编码]脏标记
     */
    @JsonIgnore
    public boolean getLevelCodeDirtyFlag(){
        return this.levelCodeDirtyFlag ;
    }

    /**
     * 获取 [组织名称]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return this.orgName ;
    }

    /**
     * 设置 [组织名称]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [组织名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return this.orgNameDirtyFlag ;
    }

    /**
     * 获取 [部门名称]
     */
    @JsonProperty("porgdeptname")
    public String getPOrgDeptName(){
        return this.pOrgDeptName ;
    }

    /**
     * 设置 [部门名称]
     */
    @JsonProperty("porgdeptname")
    public void setPOrgDeptName(String  pOrgDeptName){
        this.pOrgDeptName = pOrgDeptName ;
        this.pOrgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [部门名称]脏标记
     */
    @JsonIgnore
    public boolean getPOrgDeptNameDirtyFlag(){
        return this.pOrgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [组织标识]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return this.orgId ;
    }

    /**
     * 设置 [组织标识]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [组织标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return this.orgIdDirtyFlag ;
    }

    /**
     * 获取 [部门标识]
     */
    @JsonProperty("porgdeptid")
    public String getPOrgDeptId(){
        return this.pOrgDeptId ;
    }

    /**
     * 设置 [部门标识]
     */
    @JsonProperty("porgdeptid")
    public void setPOrgDeptId(String  pOrgDeptId){
        this.pOrgDeptId = pOrgDeptId ;
        this.pOrgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [部门标识]脏标记
     */
    @JsonIgnore
    public boolean getPOrgDeptIdDirtyFlag(){
        return this.pOrgDeptIdDirtyFlag ;
    }



}
